package com.xdja.voice.recordingControl.manager;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;

import com.xdja.voice.play.ViewSenSorStack;
import com.xdja.voice.play.VoiceMediaPlayer;
/**
 * created by flyou at2017/02/15
 *
 * 传感器监听管理类
 */
public class VoiceSenSorManager implements SensorEventListener {
    private static SensorManager sensorManager;
    private static Sensor mProximiny = null;
    private static VoiceSenSorManager instance;
    private static Context mContext;

    private VoiceSenSorManager() {
    }

    public static synchronized VoiceSenSorManager getInstance() {
        if (instance == null) {
            instance = new VoiceSenSorManager();
        }
        return instance;
    }

    @Override
    public void onSensorChanged(SensorEvent event) {
        if (VoiceMediaPlayer.isPlaying) {
            float f_proximiny = event.values[0];
            if (f_proximiny >= mProximiny.getMaximumRange()) {
                if (VoiceMediaPlayer.isPlaying) {
                    VoiceMediaPlayer.getInstance(mContext).sensorChanged(true);
                }
            } else {
                if (VoiceMediaPlayer.isPlaying) {
                    VoiceMediaPlayer.getInstance(mContext).sensorChanged(false);
                }
            }
        }
    }

    @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {

    }

    /**
     * 初始化传感器
     * @param context
     */
    public void sensorInit(Context context) {
        mContext = context;
        ViewSenSorStack.getInstance().add(this.hashCode());
        sensorManager = (SensorManager) context.getSystemService(Context.SENSOR_SERVICE);
        mProximiny = sensorManager.getDefaultSensor(Sensor.TYPE_PROXIMITY);

    }

    /**
     * 注册传感器
     */
    public void sensorRegister() {
        if (sensorManager != null && ViewSenSorStack.getInstance().getStackSize() <= 1) {
            sensorManager.registerListener(this, mProximiny,
                    SensorManager.SENSOR_DELAY_NORMAL);
        }

    }

    /**
     * 解注册传感器
     */
    public void unRegisterSensor() {
        ViewSenSorStack.getInstance().remove(this.hashCode());
        if (sensorManager != null && ViewSenSorStack.getInstance().getStackSize() == 0) {
            VoiceMediaPlayer.getInstance(mContext).stopPlay();
            sensorManager.unregisterListener(this);
        }
    }

    /**
     * 页面焦点改变监听
     * @param hasWindowFocus
     */
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        if (!hasWindowFocus) {
            VoiceMediaPlayer.getInstance(mContext).stopPlay();
        }
    }
}