package com.xdja.voice.recordingControl.view;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.LinearInterpolator;

/**
 * Created by ldy on 2017/11/1.
 */

public class PressProgressButton extends View {

    private final Paint progressPaint;
    private final Paint progressBgPaint;
    private final Paint soildPaint;
    private final int progressWidth;
    private float progress;
    private ValueAnimator animator;
    private int maxMS;
    private RectF arcOval = new RectF();
    private PressProgressListener progressListener;

    public PressProgressButton(Context context) {
        this(context, null);
    }

    public PressProgressButton(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);

        progressWidth = 24;
        progressPaint = new Paint();
        progressPaint.setStrokeWidth(progressWidth);
        progressPaint.setColor(0xff00b1ff);
        progressPaint.setStyle(Paint.Style.STROKE);
        progressPaint.setAntiAlias(true);

        progressBgPaint = new Paint();
        progressBgPaint.setStrokeWidth(24);
        progressBgPaint.setColor(0xffcccccc);
        progressBgPaint.setStyle(Paint.Style.STROKE);
        progressBgPaint.setAntiAlias(true);

        soildPaint = new Paint();
        soildPaint.setColor(0xffffffff);
        soildPaint.setAntiAlias(true);
    }

    public void setMaxMS(int maxMS) {
        this.maxMS = maxMS;
    }

    public void setProgressListener(PressProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case MotionEvent.ACTION_DOWN:
                startExpand();
                break;
            case MotionEvent.ACTION_UP:
            case MotionEvent.ACTION_CANCEL:
                if (animator != null && animator.isRunning()) {
                    animator.cancel();
                }
                break;
        }

        return true;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int centerX = getWidth() / 2;
        int centerY = getHeight() / 2;

        int progressRadius = getWidth() / 2 - progressWidth / 2;
        int soildRadius = getWidth() / 2 - progressWidth;

        canvas.drawCircle(centerX, centerY, progressRadius, progressBgPaint);
        canvas.drawCircle(centerX, centerY, soildRadius, soildPaint);

        arcOval.left = centerX - progressRadius;
        arcOval.right = centerX + progressRadius;
        arcOval.top = centerY - progressRadius;
        arcOval.bottom = centerY + progressRadius;
        canvas.drawArc(arcOval, 270, progress, false, progressPaint);
    }

    private void startExpand() {

        animate().scaleX(1.2f).scaleY(1.2f).setDuration(200)
                .setListener(new Animator.AnimatorListener() {
                    @Override
                    public void onAnimationStart(Animator animation) {
                        if (progressListener!=null){
                            progressListener.onExpandStart();
                        }
                    }

                    @Override
                    public void onAnimationEnd(Animator animation) {
                    }

                    @Override
                    public void onAnimationCancel(Animator animation) {

                    }

                    @Override
                    public void onAnimationRepeat(Animator animation) {

                    }
                })
                .start();
    }

    private void startShrink() {
        animate().scaleX(1).scaleY(1).setDuration(200)
                .setListener(new Animator.AnimatorListener() {
                    @Override
                    public void onAnimationStart(Animator animation) {

                    }

                    @Override
                    public void onAnimationEnd(Animator animation) {

                    }

                    @Override
                    public void onAnimationCancel(Animator animation) {

                    }

                    @Override
                    public void onAnimationRepeat(Animator animation) {

                    }
                })
                .start();
    }

    public void startProgress() {
        Log.d("PressProgressButton", "startProgress");

        animator = ValueAnimator.ofFloat(0, 360);
        animator.setDuration(maxMS);
        animator.setInterpolator(new LinearInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            @Override
            public void onAnimationUpdate(ValueAnimator animation) {
                setProgress((Float) animation.getAnimatedValue());
            }
        });

        animator.addListener(new Animator.AnimatorListener() {
            @Override
            public void onAnimationStart(Animator animation) {

            }

            @Override
            public void onAnimationEnd(Animator animation) {
                startShrink();
                Log.d("PressProgressButton", "录制时间:" + ((progress / 360) * maxMS));
                if (progressListener!=null){
                    progressListener.onProgressEnd((int) ((progress / 360) * maxMS));
                }
            }

            @Override
            public void onAnimationCancel(Animator animation) {
            }

            @Override
            public void onAnimationRepeat(Animator animation) {

            }
        });
        animator.start();
    }

    void setProgress(float progress) {
        this.progress = progress;
        invalidate();
    }

    public interface PressProgressListener{
        /**
         * 膨胀开始，此时应调用{@link #startProgress()}方法
         */
        void onExpandStart();

        /**
         * 进度结束
         * @param durationMs    开始到结束的时间（单位：ms）
         */
        void onProgressEnd(int durationMs);
    }

}
