package com.xdja.voice.recordingControl.view;

import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.eoa.commonutil.permission.PermissionsUtils;
import com.xdja.eoa.vca.R;
import com.xdja.voice.recordingControl.AudioFunctions;
import com.xdja.voice.recordingControl.manager.AudioManager;

import java.io.File;

public class RecordAudioActivity extends AppCompatActivity {
    /**
     * 返回结果，intent中的key值，文件路径
     */
    public static final String AUDIO_FILE_URL = "audioFileUrl";
    /**
     * 返回结果，intent中的key值，录音时长
     */
    public static final String AUDIO_DURATION_MS = "audioDurationMS";
    /**
     * 参数，intent中的key值，录音最大时间，默认{@link #DEFAULT_RECORD_MAX_MS}
     */
    public static final String RECORD_MAX_MS = "recordMaxMs";
    /**
     * 参数，intent中的key值，录音最短时间,默认{@link #DEFAULT_RECORD_MIN_MS}
     */
    public static final String RECORD_MIN_MS = "recordMinMs";


    public static int DEFAULT_RECORD_MAX_MS = 60 * 1000;
    public static int DEFAULT_RECORD_MIN_MS = 1 * 1000;

    private TextView tvDesc;
    private PressProgressButton pressProgressButton;
    private String dirPath;
    private AudioManager mAudioManager;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.voice_activity_record_audio);

        int recordMaxMs = getIntent().getIntExtra(RECORD_MAX_MS, DEFAULT_RECORD_MAX_MS);
        final int recordMinMs = getIntent().getIntExtra(RECORD_MIN_MS, DEFAULT_RECORD_MIN_MS);

        tvDesc = ((TextView) findViewById(R.id.tv_record_audio_desc));
        pressProgressButton = ((PressProgressButton) findViewById(R.id.pressProgressBtn));
        pressProgressButton.setMaxMS(recordMaxMs);
        findViewById(android.R.id.content).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBack();
            }
        });

        dirPath = getDiskCacheDir(this, "audio").getPath();
        mAudioManager = new AudioManager(dirPath);
        mAudioManager.setOnAudioStateListener(new AudioManager.AudioStateListener() {
            @Override
            public void wellPrepared() {
                pressProgressButton.startProgress();
            }

            @Override
            public void checkCurrentFocusView() {

            }

            @Override
            public void prepareFaild() {
                Toast.makeText(RecordAudioActivity.this, "启动录音失败，请重试", Toast.LENGTH_SHORT).show();
            }
        });
        pressProgressButton.setProgressListener(new PressProgressButton.PressProgressListener() {
            @Override
            public void onExpandStart() {
                if (!PermissionsUtils.havePermissionWithRequest(RecordAudioActivity.this, 12, null, PermissionsUtils.RECORD_AUDIO_PERMISSION)) {
                    return;
                }
                AudioFunctions.muteAudioFocus(RecordAudioActivity.this, true);
                mAudioManager.prepareAudio();
                tvDesc.setText(R.string.voice_up_end);
            }

            @Override
            public void onProgressEnd(int durationMs) {
                tvDesc.setText(R.string.voice_press_say);
                if (durationMs < recordMinMs) {
                    Toast.makeText(RecordAudioActivity.this, "录音时间过短，请重新录制", Toast.LENGTH_SHORT).show();
                    return;
                }
                AudioFunctions.muteAudioFocus(RecordAudioActivity.this, false);
                mAudioManager.release();
                Intent intent = new Intent();
                intent.putExtra(AUDIO_FILE_URL, mAudioManager.getCurrentFilePath());
                intent.putExtra(AUDIO_DURATION_MS,durationMs);
                setResult(RESULT_OK, intent);
                onBack();
            }
        });
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            onBack();
            return false;
        }
        return super.onKeyDown(keyCode, event);
    }

    private void onBack() {
        ActivityCompat.finishAfterTransition(this);
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }

    @NonNull
    public static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = null;
        if (Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState())
                || !Environment.isExternalStorageRemovable()) {
            File externalCacheDir = context.getExternalCacheDir();
            if (externalCacheDir != null) {
                cachePath = externalCacheDir.getPath();
            }
        }
        if (cachePath == null) {
            cachePath = context.getCacheDir().getPath();
        }

        File file = new File(cachePath + File.separator + uniqueName);
        if (!file.exists()) {
            file.mkdir();
        }
        return file;
    }
}
