package com.xdja.eoa.sdk;

import android.util.Log;

/**
 * @author jarlen
 * @date 2020/4/14
 * SDK 日志打印工具
 * adb shell setprop log.tag.eoa_sdk_log DEBUG
 */
public class SdkLog {
    public static final String TAG_LOG = "eoa_sdk_log";

    public static void d(String msg) {
        if (Log.isLoggable(SdkLog.TAG_LOG, Log.DEBUG)) {
            Thread currentThread = Thread.currentThread();
            String lineNum = "" + currentThread.getStackTrace()[3].getLineNumber();
            String className = currentThread.getStackTrace()[3].getFileName();
            Log.d(SdkLog.TAG_LOG, "[" + className + ":" + lineNum + "]  " + msg);
        }
    }

    public static void w(String msg) {
        if (Log.isLoggable(SdkLog.TAG_LOG, Log.WARN)) {
            Thread currentThread = Thread.currentThread();
            String lineNum = "" + currentThread.getStackTrace()[3].getLineNumber();
            String className = currentThread.getStackTrace()[3].getFileName();
            Log.w(SdkLog.TAG_LOG, "[" + className + ":" + lineNum + "]  " + msg);
        }
    }

    public static void w(Throwable throwable) {
        if (Log.isLoggable(SdkLog.TAG_LOG, Log.WARN)) {
            Thread currentThread = Thread.currentThread();
            String lineNum = "" + currentThread.getStackTrace()[3].getLineNumber();
            String className = currentThread.getStackTrace()[3].getFileName();
            Log.w(SdkLog.TAG_LOG, "[" + className + ":" + lineNum + "]  " + throwable);
        }
    }

    public static void e(String msg) {
        if (Log.isLoggable(SdkLog.TAG_LOG, Log.ERROR)) {
            Thread currentThread = Thread.currentThread();
            String lineNum = "" + currentThread.getStackTrace()[3].getLineNumber();
            String className = currentThread.getStackTrace()[3].getFileName();
            Log.e(SdkLog.TAG_LOG, "[" + className + ":" + lineNum + "]  " + msg, null);
        }
    }

    public static void e(Throwable throwable) {
        if (Log.isLoggable(SdkLog.TAG_LOG, Log.ERROR)) {
            Thread currentThread = Thread.currentThread();
            String lineNum = "" + currentThread.getStackTrace()[3].getLineNumber();
            String className = currentThread.getStackTrace()[3].getFileName();
            Log.e(SdkLog.TAG_LOG, "[" + className + ":" + lineNum + "]  " + "", throwable);
        }
    }

    public static void e(String msg, Throwable throwable) {
        if (Log.isLoggable(SdkLog.TAG_LOG, Log.ERROR)) {
            Thread currentThread = Thread.currentThread();
            String lineNum = "" + currentThread.getStackTrace()[3].getLineNumber();
            String className = currentThread.getStackTrace()[3].getFileName();
            Log.e(SdkLog.TAG_LOG, "[" + className + ":" + lineNum + "]  " + msg, throwable);
        }
    }
}
