package com.xdja.eoa.sdk.data.param;

import java.util.List;

/**
 * @author jarlen
 * @date 2020/4/22
 * 自定义选项选择参数
 */
public class OptionsSelectParam {

    /**
     * 支持单、多选(默认单选)
     */
    private boolean multi = false;

    /**
     * 自定义选择选项数据
     */
    private List<OptionData> optionData;

    /**
     * 已选择的数据(多选，可为空)
     */
    private List<OptionData> selectedList;

    /**
     * 已选择的数据(单选，可为空默认选择第一个)
     */
    private OptionData selected;

    public OptionData getSelected() {
        return selected;
    }

    public void setSelected(OptionData selected) {
        this.selected = selected;
    }

    public boolean isMulti() {
        return multi;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    public List<OptionData> getOptionData() {
        return optionData;
    }

    public void setOptionData(List<OptionData> optionData) {
        this.optionData = optionData;
    }

    public List<OptionData> getSelectedList() {
        return selectedList;
    }

    public void setSelectedList(List<OptionData> selectedList) {
        this.selectedList = selectedList;
    }

    public static class OptionData {
        private String key;
        private String value;

        public String getKey() {
            return key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
