package com.xdja.eoa.sdk.data.result;

/**
 * @author jarlen
 * @date 2020/3/31
 * 登录后的信息
 */
public class AccountInfo {

    /**
     * 用户ID(暂时为空)
     */
    private long userId;
    /**
     * 用户名
     */
    private String userName;

    /**
     * 用户头像
     */
    private String userAvatar;

    /**
     * 手机号
     */
    private String mobilePhone;

    /**
     * 企业ID
     */
    private long companyId;

    /**
     * 企业秘钥串
     */
    private String corporationId;

    /**
     * 单位名称
     */
    private String companyName;

    /**
     * 用户Token
     */
    private String userToken;

    /**
     * 账户绑定的芯片ID
     */
    private String chipId;

    public long getUserId() {
        return userId;
    }

    public AccountInfo setUserId(long userId) {
        this.userId = userId;
        return this;
    }

    public String getUserName() {
        return userName;
    }

    public AccountInfo setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getUserAvatar() {
        return userAvatar;
    }

    public AccountInfo setUserAvatar(String userAvatar) {
        this.userAvatar = userAvatar;
        return this;
    }

    public String getMobilePhone() {
        return mobilePhone;
    }

    public AccountInfo setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    public long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(long companyId) {
        this.companyId = companyId;
    }

    public String getCorporationId() {
        return corporationId;
    }

    public AccountInfo setCorporationId(String corporationId) {
        this.corporationId = corporationId;
        return this;
    }

    public String getCompanyName() {
        return companyName;
    }

    public AccountInfo setCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    public String getUserToken() {
        return userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public String getChipId() {
        return chipId;
    }

    public void setChipId(String chipId) {
        this.chipId = chipId;
    }

    public AccountInfo buildAccountInfo4NonSystemModule() {
        AccountInfo accountInfo = new AccountInfo();
        accountInfo.setUserId(this.userId);
        accountInfo.setUserName(this.userName);
        accountInfo.setUserToken(this.userToken);
        accountInfo.setUserAvatar(this.userAvatar);
        accountInfo.setMobilePhone(this.mobilePhone);
        accountInfo.setChipId(this.chipId);
        accountInfo.setCorporationId(this.corporationId);
        accountInfo.setCompanyName(this.companyName);
        return accountInfo;
    }

    @Override
    public String toString() {
        return "AccountInfo{" +
                "userId=" + userId +
                ", userName='" + userName + '\'' +
                ", userAvatar='" + userAvatar + '\'' +
                ", mobilePhone='" + mobilePhone + '\'' +
                ", corporationId='" + corporationId + '\'' +
                ", companyName='" + companyName + '\'' +
                ", userToken='" + userToken + '\'' +
                ", chipId='" + chipId + '\'' +
                '}';
    }
}
