package com.xdja.eoa.sdk.module;

import android.os.Parcel;
import android.os.Parcelable;

public class PushMessage implements Parcelable {

    /**
     * 消息标题
     */
    private String title;

    /**
     * 消息内容
     */
    private String content;

    /**
     * 点击事件
     */
    private String onClick;

    /**
     * 扩展字段
     */
    private String extend;

    /**
     * 修正的扩展字段
     */
    private String fixedExtend;

    public PushMessage() {
    }

    protected PushMessage(Parcel in) {
        title = in.readString();
        content = in.readString();
        onClick = in.readString();
        extend = in.readString();
        fixedExtend = in.readString();
    }

    public static final Creator<PushMessage> CREATOR = new Creator<PushMessage>() {
        @Override
        public PushMessage createFromParcel(Parcel in) {
            return new PushMessage(in);
        }

        @Override
        public PushMessage[] newArray(int size) {
            return new PushMessage[size];
        }
    };

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getOnClick() {
        return onClick;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
    }

    public String getExtend() {
        return extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public String getFixedExtend() {
        return fixedExtend;
    }

    public void setFixedExtend(String fixedExtend) {
        this.fixedExtend = fixedExtend;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(title);
        parcel.writeString(content);
        parcel.writeString(onClick);
        parcel.writeString(extend);
        parcel.writeString(fixedExtend);
    }
}
