package com.xdja.eoa.sdk.cb;

/**
 * @author jarlen
 * @date 2020/5/26
 * sdk通用接口回调
 */
public interface ICallbackListener {

    /**
     * 结果回调方法
     *
     * @param errorCode 结果码
     *                  <br/>
     *                  成功：{@link com.xdja.eoa.sdk.MethodCallErrorCode#RET_SUCCESS}
     *                  失败:其他
     * @param data      结果数据
     *                  errorCode为{@link com.xdja.eoa.sdk.MethodCallErrorCode#RET_SUCCESS} 时关注
     * @param errorMsg  错误数据
     *                  errorCode为其他值时关注
     * @param mark      接口业务标识
     */
    void onCallBackResult(int errorCode, String data, String errorMsg, String mark);
}
