package com.xdja.eoa.sdk.module;

import com.alibaba.fastjson.JSON;

/**
 * @author jarlen
 * @date 2020/5/25
 * 模块业务方法类
 */
public class MethodParam {
    /**
     * 方法名
     * <br>必传</br>
     *
     * @see com.xdja.eoa.sdk.MethodConstant
     */
    private String method;

    /**
     * 方法版本号
     * <br>非必传；默认首版本</br>
     */
    private int version;

    /**
     * 模块标识
     */
    private String moduleSn;

    /**
     * 方法调用参数；
     * <br>非必传；参数为JSON串，建议使用FastJson转换生成</br>
     */
    private String params;

    /**
     * 方法调用方业务标识
     * <br>非必传；标记使用同一个callback时的不同业务</br>
     */
    private String mark;

    private MethodParam(Builder builder) {
        this.method = builder.method;
        this.version = builder.version;
        this.params = builder.params;
        this.mark = builder.mark;
        this.moduleSn = builder.moduleSn;
    }

    public String getMethod() {
        return method;
    }

    public int getVersion() {
        return version;
    }

    public String getParams() {
        return params;
    }

    public String getMark() {
        return mark;
    }

    public String getModuleSn() {
        return moduleSn;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setModuleSn(String moduleSn) {
        this.moduleSn = moduleSn;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void setMark(String mark) {
        this.mark = mark;
    }

    @Override
    public String toString() {
        return "MethodParam{" +
                "method='" + method + '\'' +
                ", version='" + version + '\'' +
                ", appSn='" + moduleSn + '\'' +
                ", params='" + params + '\'' +
                ", mark='" + mark + '\'' +
                '}';
    }

    public static class Builder {
        /**
         * 方法名
         * <br>必传</br>
         * 详见方法常量类{@link com.xdja.eoa.sdk.MethodConstant}
         */
        String method;

        /**
         * 方法版本号
         * <br>非必传；默认首版本</br>
         */
        int version;

        /**
         * 方法调用参数
         * <br>必传；参数为JSON串，建议使用FastJson转换生成</br>
         */
        String params;

        /**
         * 方法调用方业务标识
         * <br>非必传；标记使用同一个callback时的不同业务</br>
         */
        String mark;

        /**
         * 模块标识
         * <br>从模块配置文件中获取</br>
         * {@link ModuleApplication}
         */
        String moduleSn;

        public Builder(Class<? extends IModuleApplication> moduleClass) {
            String appSn = moduleClass.getAnnotation(ModuleApp.class).moduleSn();
            this.moduleSn = appSn;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder setParams(String params) {
            this.params = params;
            return this;
        }

        public Builder setParams(Object params) {
            try {
                this.params = JSON.toJSONString(params);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return this;
        }

        public Builder setMark(String mark) {
            this.mark = mark;
            return this;
        }

        public MethodParam create() {
            return new MethodParam(this);
        }
    }

}
