package com.xdja.eoa.sdk.data;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * @author jarlen
 * @date 2020/4/3
 * 应用信息
 */
public class AppInfo implements Parcelable {

    /**
     * 应用秘钥串
     */
    private String applicationId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 应用图标
     */
    private String appIcon;

    /**
     * 应用服务地址
     */
    private String appServerUrl;

    public AppInfo() {
    }

    public String getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppIcon() {
        return appIcon;
    }

    public void setAppIcon(String appIcon) {
        this.appIcon = appIcon;
    }

    public String getAppServerUrl() {
        return appServerUrl;
    }

    public void setAppServerUrl(String appServerUrl) {
        this.appServerUrl = appServerUrl;
    }

    protected AppInfo(Parcel in) {
        applicationId = in.readString();
        appName = in.readString();
        appIcon = in.readString();
        appServerUrl = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(applicationId);
        dest.writeString(appName);
        dest.writeString(appIcon);
        dest.writeString(appServerUrl);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<AppInfo> CREATOR = new Creator<AppInfo>() {
        @Override
        public AppInfo createFromParcel(Parcel in) {
            return new AppInfo(in);
        }

        @Override
        public AppInfo[] newArray(int size) {
            return new AppInfo[size];
        }
    };
}
