package com.xdja.eoa.sdk.module;

import android.os.Bundle;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;

/**
 * @author jarlen
 * @date 2020/5/26
 * 主界面Tab 条目页接口类
 */
public interface IHomeTabPage {

    /**
     * 主界面创建完成；
     * <br>此方法调用时Tab Page并没有真正加载到主界面容器里</br>
     * 销毁见{@link #onHomePageDestroy()}
     */
    void onHomePageCreated();

    /**
     * 获取功能插件图标
     *
     * @return 插件图标
     */
    int obtainTabDrawable();

    /**
     * 获取功能插件标签
     *
     * @return 插件标签
     */
    int obtainTabTitle();

    /**
     * 获取当前功能插件对象
     *
     * @param fragmentActivity Home页Activity
     * @return 插件对象
     */
    Fragment obtainTabFragment(FragmentActivity fragmentActivity);

    /**
     * 切换当前功能插件
     * <br>(只有已经添加到Activity中才能被调用)</br>
     */
    void switchTabPage();

    /**
     * 向功能插件中发送信息
     *
     * @param activity Home页Activity
     * @param data     信息
     */
    void sendMessage(FragmentActivity activity, Bundle data);

    /**
     * 点击是否可以返回
     *
     * @return <br/>
     * False: 可以返回
     * True: 不可以返回
     */
    boolean canBack();

    /**
     * 动态移除Tab page
     */
    void onTabPageRemoved();

    /**
     * 主界面销毁
     * <br>(与{@link #onHomePageCreated()}相反)</br>
     */
    void onHomePageDestroy();

    /**
     * 启动Tab 条目页
     *
     * @return false： 没有启动Activity页面
     * true: 启动了Activity页面
     */
    boolean startTabPageActivity();
}
