package com.xdja.eoa.sdk.module;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * @author jarlen
 * @date 2020/5/25
 * 业务通知消息数据类
 */
public class PushMessage implements Parcelable {

    /**
     * 消息标题
     */
    private String title;

    /**
     * 消息内容
     */
    private String content;

    /**
     * 点击事件
     */
    private String onClick;

    /**
     * 扩展字段
     */
    private String extend;

    /**
     * 修正的扩展字段
     */
    private String fixedExtend;

    /**
     * 消息ID
     */
    private long messageId;

    /**
     * 业务ID
     */
    private String objectId;

    public PushMessage() {
    }

    protected PushMessage(Parcel in) {
        title = in.readString();
        content = in.readString();
        onClick = in.readString();
        extend = in.readString();
        fixedExtend = in.readString();
        messageId = in.readLong();
        objectId = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(title);
        dest.writeString(content);
        dest.writeString(onClick);
        dest.writeString(extend);
        dest.writeString(fixedExtend);
        dest.writeLong(messageId);
        dest.writeString(objectId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<PushMessage> CREATOR = new Creator<PushMessage>() {
        @Override
        public PushMessage createFromParcel(Parcel in) {
            return new PushMessage(in);
        }

        @Override
        public PushMessage[] newArray(int size) {
            return new PushMessage[size];
        }
    };

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getOnClick() {
        return onClick;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
    }

    public String getExtend() {
        return extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public String getFixedExtend() {
        return fixedExtend;
    }

    public void setFixedExtend(String fixedExtend) {
        this.fixedExtend = fixedExtend;
    }

    public long getMessageId() {
        return messageId;
    }

    public void setMessageId(long messageId) {
        this.messageId = messageId;
    }

    public String getObjectId() {
        return objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }
}
