/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.eoa.sdk.module;

import com.alibaba.fastjson.JSON;
import com.xdja.eoa.sdk.SdkLog;
import com.xdja.eoa.sdk.module.IModuleApplication;
import com.xdja.eoa.sdk.module.ModuleApp;

public class MethodParam {
    private String method;
    private int version;
    private String moduleSn;
    private String params;
    private String mark;

    private MethodParam(Builder builder) {
        this.method = builder.method;
        this.version = builder.version;
        this.params = builder.params;
        this.mark = builder.mark;
        this.moduleSn = builder.moduleSn;
    }

    public String getMethod() {
        return this.method;
    }

    public int getVersion() {
        return this.version;
    }

    public String getParams() {
        return this.params;
    }

    public String getMark() {
        return this.mark;
    }

    public String getModuleSn() {
        return this.moduleSn;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setModuleSn(String moduleSn) {
        this.moduleSn = moduleSn;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void setMark(String mark) {
        this.mark = mark;
    }

    public String toString() {
        return "MethodParam{method='" + this.method + '\'' + ", version='" + this.version + '\'' + ", appSn='" + this.moduleSn + '\'' + ", params='" + this.params + '\'' + ", mark='" + this.mark + '\'' + '}';
    }

    public static class Builder {
        String method;
        int version;
        String params;
        String mark;
        String moduleSn;

        public Builder(Class<? extends IModuleApplication> moduleClass) {
            String appSn;
            this.moduleSn = appSn = moduleClass.getAnnotation(ModuleApp.class).moduleSn();
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder setParams(String params) {
            this.params = params;
            return this;
        }

        public Builder setParams(Object params) {
            try {
                this.params = JSON.toJSONString((Object)params);
            }
            catch (Exception e) {
                SdkLog.w(e);
            }
            return this;
        }

        public Builder setMark(String mark) {
            this.mark = mark;
            return this;
        }

        public MethodParam create() {
            return new MethodParam(this);
        }
    }
}

