package com.xdja.eoa.sdk.data;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;

import com.xdja.eoa.sdk.module.PushMessage;

/**
 * @author jarlen
 * @date 2020/5/25
 * 模块应用通知数据结构
 */
public class ModuleNotifyData implements Parcelable {

    /**
     * 通知栏ID
     */
    private long notificationId;

    /**
     * 应用SN
     */
    private String appSn;

    /**
     * 应用ID
     */
    private long appId;

    /**
     * 扩展字段
     */
    private Bundle extendData;

    /**
     * 消息通知数据
     */
    private PushMessage pushMessage;

    public ModuleNotifyData() {
    }

    protected ModuleNotifyData(Parcel in) {
        notificationId = in.readLong();
        appSn = in.readString();
        appId = in.readLong();
        extendData = in.readBundle();
        pushMessage = in.readParcelable(PushMessage.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(notificationId);
        dest.writeString(appSn);
        dest.writeLong(appId);
        dest.writeBundle(extendData);
        dest.writeParcelable(pushMessage, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<ModuleNotifyData> CREATOR = new Creator<ModuleNotifyData>() {
        @Override
        public ModuleNotifyData createFromParcel(Parcel in) {
            return new ModuleNotifyData(in);
        }

        @Override
        public ModuleNotifyData[] newArray(int size) {
            return new ModuleNotifyData[size];
        }
    };

    public long getNotificationId() {
        return notificationId;
    }

    public void setNotificationId(long notificationId) {
        this.notificationId = notificationId;
    }

    public String getAppSn() {
        return appSn;
    }

    public void setAppSn(String appSn) {
        this.appSn = appSn;
    }

    public long getAppId() {
        return appId;
    }

    public void setAppId(long appId) {
        this.appId = appId;
    }

    public Bundle getExtendData() {
        return extendData;
    }

    public void setExtendData(Bundle extendData) {
        this.extendData = extendData;
    }

    public PushMessage getPushMessage() {
        return pushMessage;
    }

    public void setPushMessage(PushMessage pushMessage) {
        this.pushMessage = pushMessage;
    }

    @Override
    public String toString() {
        return "ModuleNotifyData{" +
                "notificationId=" + notificationId +
                ", appSn='" + appSn + '\'' +
                ", extendData=" + extendData +
                ", pushMessage=" + pushMessage +
                '}';
    }
}
