package com.xdja.eoa.sdk.module;

import android.content.Context;
import android.os.Bundle;

import com.xdja.eoa.sdk.cb.ICallbackListener;
import com.xdja.eoa.sdk.data.ModuleNotifyData;

/**
 * @author jarlen
 * @date 2020/5/25
 * 门面接口类
 */
public interface IModuleSdkFacade extends IModuleFacade {

    /**
     * sdk模块调用通用方法
     *
     * @param context  应用上下文
     * @param param    通用方法方法
     * @param listener 方法回调
     * @return
     */
    int call(Context context, MethodParam param, ICallbackListener listener);

    /**
     * 发送通知栏
     *
     * @param context    应用上下文
     * @param notifyData 通知栏数据
     */
    void sendNotification(Context context, ModuleNotifyData notifyData);

    /**
     * 获取公共配置
     * {@link SdkConstant}
     *
     * @return
     */
    Bundle getCommonConfig();
}
