package com.xdja.eoa.sdk.module;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;

/**
 * @author jarlen
 * @date 2020/4/2
 * 触发应用启动、消息分发的数据类
 */
public class ModuleData implements Parcelable {
    public static final String KEY_URI = "uri";

    /**
     * 应用启动:（来自界面点击）
     */
    public static final int ORIGIN_MODULE_APP_MAIN_LAUNCHER = 0;

    /**
     * 应用启动:(来自通知栏点击)
     */
    public static final int ORIGIN_MODULE_APP_NOTIFICATION_CLICK = 1;

    /**
     * 应用启动:(来自Uri)
     */
    public static final int ORIGIN_MODULE_APP_URI_START = 2;

    /**
     * 消息推送:(来自推送)
     */
    public static final int ORIGIN_MODULE_APP_PUSH = 3;

    /**
     * 数据来源
     *
     * @see ModuleData#ORIGIN_MODULE_APP_MAIN_LAUNCHER
     * @see ModuleData#ORIGIN_MODULE_APP_NOTIFICATION_CLICK
     * @see ModuleData#ORIGIN_MODULE_APP_URI_START
     * @see ModuleData#ORIGIN_MODULE_APP_PUSH
     */
    private int startOrigin;

    /**
     * 应用推送消息数据
     */
    private PushMessage pushMessage;

    /**
     * 应用applicationId
     */
    private String applicationId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 应用图标
     */
    private String appIcon;

    /**
     * 应用sn
     */
    private String appSn;

    /**
     * 应用ID
     */
    private long appId;

    /**
     * 应用接口服务地址
     */
    private String appServerUrl;

    /**
     * 加密的企业ID
     */
    private String corporationId;

    /**
     * 扩展字段
     */
    private Bundle extendData;

    public ModuleData() {
    }

    protected ModuleData(Parcel in) {
        startOrigin = in.readInt();
        pushMessage = in.readParcelable(PushMessage.class.getClassLoader());
        applicationId = in.readString();
        appName = in.readString();
        appIcon = in.readString();
        appSn = in.readString();
        appId = in.readLong();
        appServerUrl = in.readString();
        extendData = in.readBundle();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(startOrigin);
        dest.writeParcelable(pushMessage, flags);
        dest.writeString(applicationId);
        dest.writeString(appName);
        dest.writeString(appIcon);
        dest.writeString(appSn);
        dest.writeLong(appId);
        dest.writeString(appServerUrl);
        dest.writeBundle(extendData);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<ModuleData> CREATOR = new Creator<ModuleData>() {
        @Override
        public ModuleData createFromParcel(Parcel in) {
            return new ModuleData(in);
        }

        @Override
        public ModuleData[] newArray(int size) {
            return new ModuleData[size];
        }
    };

    public int getStartOrigin() {
        return startOrigin;
    }

    public void setStartOrigin(int startOrigin) {
        this.startOrigin = startOrigin;
    }

    public PushMessage getPushMessage() {
        return pushMessage;
    }

    public void setPushMessage(PushMessage pushMessage) {
        this.pushMessage = pushMessage;
    }

    public String getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppSn() {
        return appSn;
    }

    public void setAppSn(String appSn) {
        this.appSn = appSn;
    }

    public long getAppId() {
        return appId;
    }

    public void setAppId(long appId) {
        this.appId = appId;
    }

    public String getAppServerUrl() {
        return appServerUrl;
    }

    public void setAppServerUrl(String appServerUrl) {
        this.appServerUrl = appServerUrl;
    }

    public Bundle getExtendData() {
        return extendData;
    }

    public void setUri(Uri uri) {
        if (getExtendData() == null) {
            Bundle bundle = new Bundle();
            setExtendData(bundle);
        }
        getExtendData().putParcelable(KEY_URI, uri);
    }

    public Uri getUri() {
        if (getExtendData() == null) {
            return null;
        }
        return getExtendData().getParcelable(KEY_URI);
    }

    public void setExtendData(Bundle extendData) {
        this.extendData = extendData;
    }

    public String getAppIcon() {
        return appIcon;
    }

    public void setAppIcon(String appIcon) {
        this.appIcon = appIcon;
    }

    public String getCorporationId() {
        return corporationId;
    }

    public void setCorporationId(String corporationId) {
        this.corporationId = corporationId;
    }
}
