package com.xdja.eoa.sdk.module;

import android.os.Bundle;

import androidx.fragment.app.FragmentActivity;

/**
 * @author jarlen
 * @date 2020/5/22
 * 主界面Tab 条目页抽象类
 */
public abstract class AbsHomeTabPage implements IHomeTabPage {
    protected final FragmentActivity homeActivity;
    protected final IHomePageInterface homePageInterface;

    protected AbsHomeTabPage(FragmentActivity homeActivity, IHomePageInterface homePageInterface) {
        this.homeActivity = homeActivity;
        this.homePageInterface = homePageInterface;
    }

    @Override
    public void onHomePageCreated() {
    }

    @Override
    public void switchTabPage() {
    }

    @Override
    public void sendMessage(FragmentActivity activity, Bundle data) {
    }

    @Override
    public boolean canBack() {
        return true;
    }

    @Override
    public void onTabPageRemoved() {
    }

    @Override
    public void onHomePageDestroy() {
    }

    @Override
    public boolean startTabPageActivity() {
        return false;
    }
}
