package com.xdja.eoa.sdk.module;

/**
 * @author jarlen
 * @date 2020/5/25
 * Home页面接口
 */
public interface IHomePageInterface {
    /**
     * 是否支持tabPageValue的展示
     *
     * @param tabPageValue tab页标识
     * @return
     */
    boolean supportHomePageShow(int tabPageValue);

    /**
     * 展示Home Tab消息红点提示
     *
     * @param tabPage tab 页
     */
    void showHomeTabMsgPoint(AbsHomeTabPage tabPage);

    /**
     * 展示Home Tab消息数字提示
     *
     * @param tabPage  tab 页
     * @param msgCount 消息数量
     */
    void showHomeTabMsgCount(AbsHomeTabPage tabPage, int msgCount);

    /**
     * 隐藏Home Tab 消息展示
     *
     * @param tabPage tab 页
     */
    void hideHomeTabMsgPoint(AbsHomeTabPage tabPage);
}
