package com.xdja.eoa.sdk.module;

import android.content.Context;

/**
 * @author jarlen
 * @date 2020/5/25
 * 模块化业务接口类
 */
public interface IModuleApplication {

    /**
     * 各模块初始化完毕，{@link}时调用，
     * 应该在此调用或注册其它模块
     *
     * @param context 应用上下文
     */
    void onCreate(Context context);

    /**
     * 登录成功
     */
    void onAccountInit();

    /**
     * 退出登录
     */
    void onAccountRelease();

    /**
     * 推送数据接口
     *
     * @param data 接收推送消息，处理消息业务后，也可以发送通知栏展示;
     *             如果根据不同的业务进入的页面不一样，可以通过{@link ModuleData#getExtendData()}中携带。
     *             在通知栏点击启动时，由{@link ModuleData#getExtendData()}返回，处理跳转到不同的页面
     */
    void onReceiveModuleAppMsg(ModuleData data);

    /**
     * 启动应用事件接收
     *
     * @param data 启动所携带的数据
     */
    void onStartModuleApp(ModuleData data);

    /**
     * 主界面Tab 条目页配置Class
     *
     * @return Class<? extends AbsHomePlugin>
     */
    Class<? extends AbsHomeTabPage> obtainHomeTabPage();
}
