package com.xdja.eoa.sdk.remote;


/**
 * @author jarlen
 * @date 2020/5/19
 * 跨进程方法调用参数
 */
public class RemoteMethodParam {

    /**
     * 方法名
     */
    private String method;

    /**
     * 方法版本号
     */
    private String version;

    /**
     * 方法(api)调用权限；
     * <p>仅对部分方法使用</p>
     */
    private String apiAccessCode;

    /**
     * 调用方身份码
     */
    private String identityCode;

    /**
     * 方法调用参数
     */
    private String params;

    /**
     * 方法调用方标识
     */
    private String mark;

    public String getMethod() {
        return method;
    }

    public RemoteMethodParam setMethod(String method) {
        this.method = method;
        return this;
    }

    public String getVersion() {
        return version;
    }

    public RemoteMethodParam setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getApiAccessCode() {
        return apiAccessCode;
    }

    public RemoteMethodParam setApiAccessCode(String apiAccessCode) {
        this.apiAccessCode = apiAccessCode;
        return this;
    }

    public String getIdentityCode() {
        return identityCode;
    }

    public RemoteMethodParam setIdentityCode(String identityCode) {
        this.identityCode = identityCode;
        return this;
    }

    public String getParams() {
        return params;
    }

    public RemoteMethodParam setParams(String params) {
        this.params = params;
        return this;
    }

    public String getMark() {
        return mark;
    }

    public RemoteMethodParam setMark(String mark) {
        this.mark = mark;
        return this;
    }
}
