package com.xdja.eoa.host.bean;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by @author zhuruyi on 2020/5/20
 */
public class HostPluginParam implements Parcelable {
    public static final String KEY_URI = "uri";

    /**
     * 应用启动:（来自界面点击）
     */
    public static final int ORIGIN_MODULE_APP_MAIN_LAUNCHER = 0;

    /**
     * 应用启动:(来自通知栏点击)
     */
    public static final int ORIGIN_MODULE_APP_NOTIFICATION_CLICK = 1;

    /**
     * 应用启动:(来自Uri)
     */
    public static final int ORIGIN_MODULE_APP_URI_START = 2;

    /**
     * 消息推送:(来自推送)
     */
    public static final int ORIGIN_MODULE_APP_PUSH = 3;

    /**
     * 数据来源
     *
     * @see HostPluginParam#ORIGIN_MODULE_APP_MAIN_LAUNCHER
     * @see HostPluginParam#ORIGIN_MODULE_APP_NOTIFICATION_CLICK
     * @see HostPluginParam#ORIGIN_MODULE_APP_URI_START
     * @see HostPluginParam#ORIGIN_MODULE_APP_PUSH
     */
    private int startOrigin;

    /**
     * 应用推送消息数据
     */
    private HostPluginPushMessage pushMessage;

    /**
     * 应用applicationId
     */
    private String applicationId;

    /**
     * 企业id
     */
    private String corpId;

    /**
     * 插件身份码
     */
    private String identityCode;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 应用图标
     */
    private String appIcon;

    /**
     * 应用SN
     */
    private String appSn;

    /**
     * 应用接口服务地址
     */
    private String appServerUrl;

    /**
     * 扩展字段
     */
    private Bundle extendData;

    public HostPluginParam() {
    }

    protected HostPluginParam(Parcel in) {
        startOrigin = in.readInt();
        pushMessage = in.readParcelable(HostPluginPushMessage.class.getClassLoader());
        applicationId = in.readString();
        corpId = in.readString();
        identityCode = in.readString();
        appName = in.readString();
        appIcon = in.readString();
        appSn = in.readString();
        appServerUrl = in.readString();
        extendData = in.readBundle(getClass().getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(startOrigin);
        dest.writeParcelable(pushMessage, flags);
        dest.writeString(applicationId);
        dest.writeString(corpId);
        dest.writeString(identityCode);
        dest.writeString(appName);
        dest.writeString(appIcon);
        dest.writeString(appSn);
        dest.writeString(appServerUrl);
        dest.writeBundle(extendData);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<HostPluginParam> CREATOR = new Creator<HostPluginParam>() {
        @Override
        public HostPluginParam createFromParcel(Parcel in) {
            return new HostPluginParam(in);
        }

        @Override
        public HostPluginParam[] newArray(int size) {
            return new HostPluginParam[size];
        }
    };

    public int getStartOrigin() {
        return this.startOrigin;
    }

    public void setStartOrigin(int startOrigin) {
        this.startOrigin = startOrigin;
    }

    public HostPluginPushMessage getPushMessage() {
        return this.pushMessage;
    }

    public void setPushMessage(HostPluginPushMessage pushMessage) {
        this.pushMessage = pushMessage;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getCorpId() {
        return corpId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public String getIdentityCode() {
        return identityCode;
    }

    public void setIdentityCode(String identityCode) {
        this.identityCode = identityCode;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppSn() {
        return this.appSn;
    }

    public void setAppSn(String appSn) {
        this.appSn = appSn;
    }

    public String getAppServerUrl() {
        return this.appServerUrl;
    }

    public void setAppServerUrl(String appServerUrl) {
        this.appServerUrl = appServerUrl;
    }

    public Bundle getExtendData() {
        return this.extendData;
    }

    public void setUri(Uri uri) {
        if (this.getExtendData() == null) {
            Bundle bundle = new Bundle();
            this.setExtendData(bundle);
        }

        this.getExtendData().putParcelable(KEY_URI, uri);
    }

    public Uri getUri() {
        return this.getExtendData() == null ? null : (Uri) this.getExtendData().getParcelable(KEY_URI);
    }

    public void setExtendData(Bundle extendData) {
        this.extendData = extendData;
    }

    public String getAppIcon() {
        return this.appIcon;
    }

    public void setAppIcon(String appIcon) {
        this.appIcon = appIcon;
    }
}
