package com.xdja.eoa.host.bean;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by @author zhuruyi on 2020/5/20
 */
public class HostPluginPushMessage implements Parcelable {

    /**
     * 消息标题
     */
    private String title;

    /**
     * 消息内容
     */
    private String content;

    /**
     * 点击事件
     */
    private String onClick;

    /**
     * 扩展字段
     */
    private String extend;

    /**
     * 修正的扩展字段
     */
    private String fixedExtend;

    /**
     * 消息ID
     */
    private long messageId;

    /**
     * 业务ID
     */
    private String objectId;

    public HostPluginPushMessage(){

    }

    protected HostPluginPushMessage(Parcel in) {
        title = in.readString();
        content = in.readString();
        onClick = in.readString();
        extend = in.readString();
        fixedExtend = in.readString();
        messageId = in.readLong();
        objectId = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(title);
        dest.writeString(content);
        dest.writeString(onClick);
        dest.writeString(extend);
        dest.writeString(fixedExtend);
        dest.writeLong(messageId);
        dest.writeString(objectId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<HostPluginPushMessage> CREATOR = new Creator<HostPluginPushMessage>() {
        @Override
        public HostPluginPushMessage createFromParcel(Parcel in) {
            return new HostPluginPushMessage(in);
        }

        @Override
        public HostPluginPushMessage[] newArray(int size) {
            return new HostPluginPushMessage[size];
        }
    };

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getOnClick() {
        return onClick;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
    }

    public String getExtend() {
        return extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public String getFixedExtend() {
        return fixedExtend;
    }

    public void setFixedExtend(String fixedExtend) {
        this.fixedExtend = fixedExtend;
    }

    public long getMessageId() {
        return messageId;
    }

    public void setMessageId(long messageId) {
        this.messageId = messageId;
    }

    public String getObjectId() {
        return objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }
}
