package com.xdja.eoa.sdk.remote;

import android.content.Intent;
import android.os.Bundle;

import com.alibaba.fastjson.JSON;
import com.xdja.eoa.host.bean.HostPluginParam;
import com.xdja.eoa.sdk.cb.ICallbackListener;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/**
 * @author jarlen
 * @date 2020/5/26
 * RemoteSdk 工具类
 */

public class RemoteSdkUtils {

    /**
     * 转换ICallbackListener
     *
     * @param remoteMethodParam 方法参数
     * @param listener          回调
     * @return
     */
    public static Bundle getBundleForCallBinder(RemoteMethodParam remoteMethodParam, ICallbackListener listener) {
        Bundle bundle = new Bundle();
        String methodData = JSON.toJSONString(remoteMethodParam);
        bundle.putString(RemoteSdkConstant.KEY_BINDER_CALL_METHOD_DATA, methodData);
        if (listener != null) {
            RealCallBack cb = RealCallBack.create(listener, remoteMethodParam.getMark());
            bundle.putBinder(RemoteSdkConstant.KEY_BINDER_CALL_METHOD_CALLBACK, cb);
        }
        return bundle;
    }

    /**
     * 字符串的压缩
     *
     * @param str 待压缩的字符串
     * @return 返回压缩后的字符串
     * @throws IOException
     */
    public static String compress(String str) throws IOException {
        if (null == str || str.length() <= 0) {
            return str;
        }
        // 创建一个新的输出流
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        // 使用默认缓冲区大小创建新的输出流
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        // 将字节写入此输出流
        gzip.write(str.getBytes("utf-8"));
        gzip.close();
        // 使用指定的 charsetName，通过解码字节将缓冲区内容转换为字符串
        return out.toString("ISO-8859-1");
    }

    /**
     * 字符串的解压
     *
     * @param str 对字符串解压
     * @return 返回解压缩后的字符串
     * @throws IOException
     */
    public static String unCompress(String str) throws IOException {
        if (null == str || str.length() <= 0) {
            return str;
        }
        // 创建一个新的输出流
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        // 创建一个 ByteArrayInputStream，使用 buf 作为其缓冲区数组
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes("ISO-8859-1"));
        // 使用默认缓冲区大小创建新的输入流
        GZIPInputStream gzip = new GZIPInputStream(in);
        byte[] buffer = new byte[256];
        int n = 0;

        // 将未压缩数据读入字节数组
        while ((n = gzip.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
        // 使用指定的 charsetName，通过解码字节将缓冲区内容转换为字符串
        return out.toString("utf-8");
    }

    /**
     * 从Intent中获取插件初始化参数
     *
     * @param intent 从宿主而来的Intent
     * @return 插件初始化参数
     */
    public static HostPluginParam parsePluginParam(Intent intent) {
        if (intent == null || !intent.hasExtra(RemoteSdkConstant.KEY_PLUGIN_PARAMS)) {
            return null;
        }
        HostPluginParam pluginParam = intent.getParcelableExtra(RemoteSdkConstant.KEY_PLUGIN_PARAMS);
        return pluginParam;
    }
}
