package com.xdja.eoa.sdk.remote;

import android.os.Bundle;

import com.alibaba.fastjson.JSON;
import com.xdja.eoa.sdk.remote.cb.ICallbackListener;
import com.xdja.eoa.sdk.remote.cb.RealCallBack;

public class BundleHandle {

    public static Bundle getBundleForCallBinder(RemoteMethodParam remoteMethodParam, ICallbackListener listener) {
        Bundle bundle = new Bundle();
        String methodData = JSON.toJSONString(remoteMethodParam);
        bundle.putString(ParamConstant.KEY_BINDER_CALL_METHOD_DATA, methodData);
        if (listener != null) {
            RealCallBack cb = RealCallBack.create(listener, remoteMethodParam.getMark());
            bundle.putBinder(ParamConstant.KEY_BINDER_CALL_METHOD_CALLBACK, cb);
        }
        return bundle;
    }
}
