package com.xdja.eoa.sdk.remote;

import android.util.Log;

/**
 * @author jarlen
 * @date 2020/4/14
 * SDK 日志打印工具
 */
public class SdkLog {
    public static void d(String msg) {
        if (Log.isLoggable(RemoteSdkConstant.TAG_LOG, Log.DEBUG)) {
            Thread currentThread = Thread.currentThread();
            String lineNum = "" + currentThread.getStackTrace()[3].getLineNumber();
            String className = currentThread.getStackTrace()[3].getFileName();
            Log.d(RemoteSdkConstant.TAG_LOG, "[" + className + ":" + lineNum + "]  " + msg);
        }
    }

    public static void w(String msg) {
        if (Log.isLoggable(RemoteSdkConstant.TAG_LOG, Log.WARN)) {
            Thread currentThread = Thread.currentThread();
            String lineNum = "" + currentThread.getStackTrace()[3].getLineNumber();
            String className = currentThread.getStackTrace()[3].getFileName();
            Log.w(RemoteSdkConstant.TAG_LOG, "[" + className + ":" + lineNum + "]  " + msg);
        }
    }

    public static void w(Throwable throwable) {
        if (Log.isLoggable(RemoteSdkConstant.TAG_LOG, Log.WARN)) {
            Thread currentThread = Thread.currentThread();
            String lineNum = "" + currentThread.getStackTrace()[3].getLineNumber();
            String className = currentThread.getStackTrace()[3].getFileName();
            Log.w(RemoteSdkConstant.TAG_LOG, "[" + className + ":" + lineNum + "]  " + throwable);
        }
    }

    public static void e(String msg) {
        if (Log.isLoggable(RemoteSdkConstant.TAG_LOG, Log.ERROR)) {
            Thread currentThread = Thread.currentThread();
            String lineNum = "" + currentThread.getStackTrace()[3].getLineNumber();
            String className = currentThread.getStackTrace()[3].getFileName();
            Log.e(RemoteSdkConstant.TAG_LOG, "[" + className + ":" + lineNum + "]  " + msg);
        }
    }
}
