/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ecdatasync.client;

import com.xdja.ecdatasync.client.EsClient;
import com.xdja.ecdatasync.config.SyncConfig;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataSyncTask {
    private static Logger logger = LoggerFactory.getLogger(DataSyncTask.class);
    private final long ecssSyncStartDelay = 10L;
    protected ThreadFactory ecssSyncFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "DataSyncData");
            return thread;
        }
    };

    protected void start(SyncConfig config) {
        try {
            ScheduledThreadPoolExecutor checkFsTask = new ScheduledThreadPoolExecutor(1, this.ecssSyncFactory);
            checkFsTask.scheduleWithFixedDelay(this.ecssSyncFactory.newThread(new DataSyncData()), 10L, config.getSyncDelay(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("DataSyncTask start failed!", (Throwable)e);
            throw e;
        }
    }

    protected class DataSyncData
    implements Runnable {
        @Override
        public void run() {
            try {
                EsClient esClient = EsClient.getEsClient(null);
                esClient.loadEsData();
            }
            catch (Exception e) {
                logger.warn("loadEsDataByEcCode exception!exception:{}", (Object)e.getMessage());
            }
        }
    }
}

