/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ecdatasync.client;

import com.alibaba.fastjson.JSONObject;
import com.rabbitmq.client.Channel;
import com.xdja.ecdatasync.client.EsClient;
import com.xdja.ecdatasync.common.enums.TypeEnum;
import com.xdja.ecdatasync.config.MsgConfig;
import com.xdja.ecdatasync.config.SyncConfig;
import com.xdja.sc.client.consumer.ReceivedAction;
import com.xdja.sc.client.core.MQSetting;
import com.xdja.sc.model.Msg;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcMqClient {
    private final int ecssSyncTimes = 4;
    private static Logger logger = LoggerFactory.getLogger(EcMqClient.class);

    protected void init(SyncConfig syncConfig, MsgConfig msgConfig) {
        if (msgConfig.getMsgOpen() == 1) {
            try {
                MQSetting.init((String)msgConfig.getUsername(), (String)msgConfig.getPassword(), (String)msgConfig.getUrl(), (String)msgConfig.getQueuename());
                logger.info("init EsMqClient  success!");
                this.processMsg(syncConfig, msgConfig);
            }
            catch (Exception e) {
                logger.error("init EsMqClient  failed!", (Throwable)e);
            }
        }
    }

    private void processMsg(final SyncConfig syncConfig, MsgConfig msgConfig) throws Exception {
        MQSetting.registAction((ReceivedAction)new ReceivedAction(){
            boolean mqResult = false;
            EsClient esClient = EsClient.getEsClient(syncConfig);

            public void delivery(Msg msg, long deliveryTag, Channel channel, boolean autoAck) {
                String ecCode;
                String type;
                JSONObject jsonObject;
                if (msg.type.equals("loginType@" + syncConfig.getAppId())) {
                    try {
                        jsonObject = JSONObject.parseObject((String)msg.content);
                        type = jsonObject.getString("loginType");
                        ecCode = jsonObject.getString("ecCode");
                        this.mqResult = this.esClient.loginType(type, ecCode);
                        logger.debug("\u5b89\u901a+  LoginType by mq success!");
                    }
                    catch (Exception e) {
                        logger.warn("\u5b89\u901a+  LoginType by mq exception:{}", (Throwable)e);
                    }
                } else if (msg.type.equals(TypeEnum.MsgType.EC_GROUP_CHANGE.getCode())) {
                    try {
                        jsonObject = JSONObject.parseObject((String)msg.content);
                        ecCode = jsonObject.getString("groupId");
                        this.mqResult = this.esClient.loadEsCompanyGroupByUpdateSerial(null, Long.valueOf(ecCode));
                        logger.debug("load ec by mq by mq success!");
                    }
                    catch (Exception e) {
                        logger.warn("load ec by mq have exception:{}", (Throwable)e);
                    }
                } else if (msg.type.equals(TypeEnum.MsgType.EC_CHANGE.getCode())) {
                    try {
                        jsonObject = JSONObject.parseObject((String)msg.content);
                        ecCode = jsonObject.getString("ecCode");
                        this.mqResult = this.esClient.loadEsCompanyByUpdateSerial(null, ecCode);
                        logger.debug("load ec by mq by mq success!");
                    }
                    catch (Exception e) {
                        logger.warn("load ec by mq have exception:{}", (Throwable)e);
                    }
                } else if (msg.type.equals(TypeEnum.MsgType.DEPT_CHANGE.getCode())) {
                    try {
                        jsonObject = JSONObject.parseObject((String)msg.content);
                        ecCode = jsonObject.getString("ecCode");
                        this.mqResult = this.esClient.loadEsDeptByUpdateSerial(null, ecCode);
                        logger.debug("load dept by mq by mq success!");
                    }
                    catch (Exception e) {
                        logger.warn("load dept by mq have exception:{}", (Throwable)e);
                    }
                } else if (msg.type.equals(TypeEnum.MsgType.MEMBER_CHANGE.getCode())) {
                    try {
                        jsonObject = JSONObject.parseObject((String)msg.content);
                        ecCode = jsonObject.getString("ecCode");
                        this.mqResult = this.esClient.loadEsMemberByUpdateSerial(null, ecCode);
                        logger.debug("load member by mq by mq success!");
                    }
                    catch (Exception e) {
                        logger.warn("load member by mq have exception:{}", (Throwable)e);
                    }
                } else if (msg.type.equals("appChange@" + syncConfig.getAppId())) {
                    try {
                        jsonObject = JSONObject.parseObject((String)msg.content);
                        ecCode = jsonObject.getString("ecCode");
                        type = jsonObject.getString("type");
                        if (type.equals(TypeEnum.MsgType.EC_CLOSE.getCode())) {
                            this.mqResult = this.esClient.companyClose(ecCode);
                        } else if (type.equals(TypeEnum.MsgType.EC_OPEN.getCode())) {
                            this.mqResult = this.esClient.companyOpen(ecCode);
                        }
                        logger.debug("company open/close by mq success!");
                    }
                    catch (Exception e) {
                        logger.warn("company open/close by mq have exception:{}", (Throwable)e);
                    }
                }
                if (!autoAck) {
                    try {
                        if (this.mqResult) {
                            channel.basicAck(deliveryTag, true);
                            logger.info("Handling msg success by msg : {}", (Object)msg.type);
                        } else {
                            int failTimes = 4;
                            while (--failTimes > 0) {
                                logger.info("execute msg fail, retry {}th times ", (Object)(4 - failTimes));
                                if (!this.mqResult) continue;
                                logger.info("retry success , Handling msg success");
                                channel.basicAck(deliveryTag, true);
                                break;
                            }
                            if (failTimes == 0) {
                                channel.basicAck(deliveryTag, true);
                                logger.error("Looped {}th times but failed , This msg will be deleted", (Object)3);
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.warn("Exceptions occur when  processing completes validation\uff01", (Throwable)e);
                    }
                }
            }
        }, (boolean)true);
    }
}

