/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ecdatasync.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.ecdatasync.common.enums.TypeEnum;
import com.xdja.ecdatasync.config.SyncConfig;
import com.xdja.ecdatasync.entity.CompanyFilterEntity;
import com.xdja.ecdatasync.entity.DataSyncEntity;
import com.xdja.ecdatasync.entity.IncrementSyncEntity;
import com.xdja.ecdatasync.entity.MsgEntity;
import com.xdja.ecdatasync.model.AdminInfo;
import com.xdja.ecdatasync.model.CompanyGroup;
import com.xdja.ecdatasync.model.CompanyInfo;
import com.xdja.ecdatasync.model.DeptInfo;
import com.xdja.ecdatasync.model.Member;
import com.xdja.ecdatasync.observable.CompanyFilterServer;
import com.xdja.ecdatasync.observable.DataSyncServer;
import com.xdja.ecdatasync.observable.MsgServer;
import com.xdja.ecdatasync.util.HttpClientUtils;
import com.xdja.ecdatasync.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsClient {
    private static Logger logger = LoggerFactory.getLogger(EsClient.class);
    private final int ecPageSize = 500;
    private static EsClient esClient = null;
    private static SyncConfig syncConfig = null;
    private CompanyFilterServer companyFilterServer = CompanyFilterServer.getCompanyFilterServer();
    private MsgServer msgServer = MsgServer.getMsgServer();
    private DataSyncServer dataSyncServer = DataSyncServer.getDataSyncServer();

    private EsClient() {
    }

    public static EsClient getEsClient(SyncConfig config) {
        if (null == esClient) {
            esClient = new EsClient();
        }
        if (null == syncConfig) {
            syncConfig = config;
        }
        return esClient;
    }

    protected final boolean loadEsCompanyGroupByUpdateSerial(Long seq, Long groupId) {
        long companyGroupLastUpdateSeq = 0L;
        List<CompanyGroup> companyGroupList = new ArrayList();
        try {
            Integer code;
            HashMap<String, String> header = new HashMap<String, String>(1);
            header.put("appId", syncConfig.getAppId());
            JSONObject body = new JSONObject();
            String result = null;
            if (Utils.checkLong(groupId)) {
                body.put("groupId", (Object)groupId);
                result = HttpClientUtils.post(syncConfig.getCompanyGroupIdSyncUri(), header, body.toJSONString(), "application/json", "UTF-8", null, null);
            } else {
                body.put("pageSize", (Object)500);
                IncrementSyncEntity entity = new IncrementSyncEntity();
                entity.setTypeEnum(TypeEnum.IncrementSyncType.COMPANY_GROUP_SERIAL);
                if (null == seq) {
                    Object lastUpdateSeq = this.dataSyncServer.update(entity);
                    if (null == lastUpdateSeq) {
                        logger.warn("COMPANY_GROUP Observer is empty");
                        return false;
                    }
                    companyGroupLastUpdateSeq = !Utils.checkLong((Long)lastUpdateSeq) ? 0L : (Long)lastUpdateSeq;
                } else {
                    companyGroupLastUpdateSeq = seq;
                }
                body.put("lastUpdateStatus", (Object)companyGroupLastUpdateSeq);
                result = HttpClientUtils.post(syncConfig.getCompanyGroupSerialSyncUri(), header, body.toJSONString(), "application/json", "UTF-8", null, null);
            }
            if (result == null) {
                logger.warn("load companyGroup by updateSerial or groupId happened warn , result is null!");
                return false;
            }
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (jsonObject.containsKey((Object)"code") && Utils.checkInteger(code = jsonObject.getInteger("code"))) {
                if (TypeEnum.ErrorCode.OVER_LIMIT.getCode().equals(code)) {
                    logger.info("over limit rate, result :{}", (Object)result);
                    return false;
                }
                if (1 != code) {
                    logger.info("load companyGroup by updateSerial or groupId fail,result code :{}", (Object)result);
                    return false;
                }
            }
            if (jsonObject.containsKey((Object)"data")) {
                if (Utils.checkLong(groupId)) {
                    JSONObject json = jsonObject.getJSONObject("data");
                    CompanyGroup group = (CompanyGroup)JSONObject.parseObject((String)json.toJSONString(), CompanyGroup.class);
                    if (null != group) {
                        companyGroupList.add(group);
                    }
                } else {
                    JSONArray jsonArray = jsonObject.getJSONArray("data");
                    companyGroupList = JSON.parseArray((String)jsonArray.toJSONString(), CompanyGroup.class);
                }
            }
            if (!Utils.checkCollection(companyGroupList)) {
                logger.info("load companyGroup by updateSerial or groupId success,but result companyGroupList is empty");
                return true;
            }
            for (CompanyGroup companyGroup : companyGroupList) {
                if (companyGroup.getLastUpdateStatus() <= companyGroupLastUpdateSeq) continue;
                companyGroupLastUpdateSeq = companyGroup.getLastUpdateStatus();
            }
            DataSyncEntity entity = new DataSyncEntity();
            boolean updateResult = this.dataEntityUpdate(entity, TypeEnum.DataSyncType.COMPANY_GROUP_SYNC, Utils.checkLong(groupId) ? -1L : companyGroupLastUpdateSeq, companyGroupList);
            if (!updateResult) {
                logger.warn("\u4e09\u65b9\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
                return false;
            }
            if (companyGroupList != null && companyGroupList.size() >= 500) {
                this.loadEsCompanyGroupByUpdateSerial(companyGroupLastUpdateSeq, groupId);
            }
            return true;
        }
        catch (Exception e) {
            logger.warn("load companyGroup by updateSerial or groupId happened :{}", (Throwable)e);
            return false;
        }
    }

    protected final boolean loadEsCompanyByUpdateSerial(Long seq, String ecCode) {
        long companyLastUpdateSeq = 0L;
        List<Object> companyList = new ArrayList();
        try {
            Integer code;
            boolean isCheckEcCode;
            int filterOpen = syncConfig.getFilterOpen();
            CompanyFilterEntity entity = new CompanyFilterEntity();
            entity.setTypeEnum(TypeEnum.CompanyFilterType.COMPANY_CODES);
            Set ecCodes = (Set)this.companyFilterServer.update(entity);
            boolean bl = isCheckEcCode = 1 == filterOpen;
            if (isCheckEcCode && !Utils.checkCollection(ecCodes) && !Utils.checkString(ecCode)) {
                logger.warn("load company by updateSerial or ecCode  happened warn , the filter is Open but the ecCodes is null");
                return false;
            }
            HashMap<String, String> header = new HashMap<String, String>(1);
            header.put("appId", syncConfig.getAppId());
            JSONObject body = new JSONObject();
            String result = null;
            if (Utils.checkString(ecCode)) {
                body.put("ecCode", (Object)ecCode);
                result = HttpClientUtils.post(syncConfig.getCompanyCodeSyncUri(), header, body.toJSONString(), "application/json", "UTF-8", null, null);
            } else {
                body.put("pageSize", (Object)500);
                IncrementSyncEntity seqEntity = new IncrementSyncEntity();
                seqEntity.setTypeEnum(TypeEnum.IncrementSyncType.COMPANY_SERIAL);
                if (null == seq) {
                    Object lastUpdateSeq = this.dataSyncServer.update(seqEntity);
                    if (null == lastUpdateSeq) {
                        logger.warn("COMPANY Observer is empty");
                        return false;
                    }
                    companyLastUpdateSeq = !Utils.checkLong((Long)lastUpdateSeq) ? 0L : (Long)lastUpdateSeq;
                } else {
                    companyLastUpdateSeq = seq;
                }
                body.put("lastUpdateStatus", (Object)companyLastUpdateSeq);
                result = HttpClientUtils.post(syncConfig.getCompanySerialSyncUri(), header, body.toJSONString(), "application/json", "UTF-8", null, null);
            }
            if (result == null) {
                logger.warn("load company by updateSerial or ecCode  happened warn,result is null!");
                return false;
            }
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (jsonObject.containsKey((Object)"code") && Utils.checkInteger(code = jsonObject.getInteger("code")) && TypeEnum.ErrorCode.OVER_LIMIT.getCode().equals(code)) {
                logger.info("over limit rate, result :{}", (Object)result);
                return false;
            }
            if (jsonObject.containsKey((Object)"success") && !jsonObject.getBoolean("success").booleanValue()) {
                logger.info("load company by updateSerial or ecCode fail , result :{}", (Object)result);
                return false;
            }
            if (jsonObject.containsKey((Object)"data")) {
                if (Utils.checkString(ecCode)) {
                    JSONObject json = jsonObject.getJSONObject("data");
                    CompanyInfo company = (CompanyInfo)JSONObject.parseObject((String)json.toJSONString(), CompanyInfo.class);
                    if (null != company) {
                        companyList.add(company);
                    }
                } else {
                    JSONArray jsonArray = jsonObject.getJSONArray("data");
                    companyList = JSON.parseArray((String)jsonArray.toJSONString(), CompanyInfo.class);
                }
            }
            if (!Utils.checkCollection(companyList)) {
                logger.info("load company by updateSerial or ecCode success,but result companyList is empty");
                return true;
            }
            ArrayList<CompanyInfo> companys = new ArrayList<CompanyInfo>();
            for (CompanyInfo companyInfo : companyList) {
                if (companyInfo.getLastUpdateStatus() > companyLastUpdateSeq) {
                    companyLastUpdateSeq = companyInfo.getLastUpdateStatus();
                }
                if (isCheckEcCode && !ecCodes.contains(companyInfo.getCode())) continue;
                companys.add(companyInfo);
            }
            if (!Utils.checkCollection(companys)) {
                logger.info("load company by updateSerial or ecCode success,but result companyList is not need");
                return true;
            }
            DataSyncEntity companyEntity = new DataSyncEntity();
            boolean bl2 = this.dataEntityUpdate(companyEntity, TypeEnum.DataSyncType.COMPANY_SYNC, Utils.checkString(ecCode) ? -1L : companyLastUpdateSeq, companys);
            if (!bl2) {
                logger.warn("\u4e09\u65b9\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
                return false;
            }
            if (companys != null && companys.size() >= 500) {
                this.loadEsCompanyByUpdateSerial(companyLastUpdateSeq, ecCode);
            }
            return true;
        }
        catch (Exception e) {
            logger.warn("load company by updateSerial or ecCode happened :{}", (Throwable)e);
            return false;
        }
    }

    protected final boolean loadEsDeptByUpdateSerial(Long seq, String ecCode) {
        long deptLastUpdateSeq = 0L;
        try {
            Integer code;
            if (!Utils.checkString(ecCode)) {
                logger.info("load dept by updateSerial and ecCode happened warn,the param ecCode is null");
                return false;
            }
            if (null == seq) {
                IncrementSyncEntity<String> entity = new IncrementSyncEntity<String>();
                entity.setTypeEnum(TypeEnum.IncrementSyncType.DEPT_SERIAL);
                entity.setData(ecCode);
                Object deptSeq = this.dataSyncServer.update((IncrementSyncEntity)entity);
                if (null == deptSeq) {
                    logger.warn("Dept Observer is empty");
                    return false;
                }
                deptLastUpdateSeq = !Utils.checkLong((Long)deptSeq) ? 0L : (Long)deptSeq;
            } else {
                deptLastUpdateSeq = seq;
            }
            JSONObject body = new JSONObject();
            body.put("ecCode", (Object)ecCode);
            body.put("lastUpdateStatus", (Object)deptLastUpdateSeq);
            body.put("pageSize", (Object)500);
            HashMap<String, String> header = new HashMap<String, String>(1);
            header.put("appId", syncConfig.getAppId());
            String result = HttpClientUtils.post(syncConfig.getDeptSyncUri(), header, body.toJSONString(), "application/json", "UTF-8", null, null);
            if (result == null) {
                logger.warn("load dept by updateSerial and ecCode happened warn , result is null!");
                return false;
            }
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (jsonObject.containsKey((Object)"code") && Utils.checkInteger(code = jsonObject.getInteger("code")) && TypeEnum.ErrorCode.OVER_LIMIT.getCode().equals(code)) {
                logger.info("over limit rate, result :{}", (Object)result);
                return false;
            }
            if (jsonObject.containsKey((Object)"success") && !jsonObject.getBoolean("success").booleanValue()) {
                logger.info("load dept by updateSerial and ecCode fail , result :{}", (Object)result);
                return false;
            }
            if (jsonObject.containsKey((Object)"data")) {
                JSONArray jsonArray = jsonObject.getJSONArray("data");
                List deptList = JSON.parseArray((String)jsonArray.toJSONString(), DeptInfo.class);
                if (!Utils.checkCollection(deptList)) {
                    logger.info("load dept by updateSerial and ecCode success,but result deptList is empty");
                    return true;
                }
                for (DeptInfo dept : deptList) {
                    if (dept.getLastUpdateStatus() <= deptLastUpdateSeq) continue;
                    deptLastUpdateSeq = dept.getLastUpdateStatus();
                }
                DataSyncEntity deptEntity = new DataSyncEntity();
                boolean updateResult = this.dataEntityUpdate(deptEntity, TypeEnum.DataSyncType.DEPT_SYNC, deptLastUpdateSeq, deptList);
                if (!updateResult) {
                    logger.warn("\u4e09\u65b9\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
                    return false;
                }
                if (deptList != null && deptList.size() >= 500) {
                    this.loadEsDeptByUpdateSerial(deptLastUpdateSeq, ecCode);
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.warn("load dept by updateSerial and ecCode happened :{}", (Throwable)e);
            return false;
        }
    }

    protected final boolean loadEsMemberByUpdateSerial(Long seq, String ecCode) {
        long memberLastUpdateSeq = 0L;
        try {
            Integer code;
            if (!Utils.checkString(ecCode)) {
                logger.info("load member by updateSerial and ecCode happened warn,the param ecCode is null");
                return false;
            }
            if (null == seq) {
                IncrementSyncEntity<String> memberEntity = new IncrementSyncEntity<String>();
                memberEntity.setTypeEnum(TypeEnum.IncrementSyncType.MEMBER_SERIAL);
                memberEntity.setData(ecCode);
                Object memberSeq = this.dataSyncServer.update((IncrementSyncEntity)memberEntity);
                if (null == memberSeq) {
                    logger.warn("Member Observer is empty");
                    return false;
                }
                memberLastUpdateSeq = !Utils.checkLong((Long)memberSeq) ? 0L : (Long)memberSeq;
            } else {
                memberLastUpdateSeq = seq;
            }
            JSONObject body = new JSONObject();
            body.put("ecCode", (Object)ecCode);
            body.put("lastUpdateStatus", (Object)memberLastUpdateSeq);
            body.put("pageSize", (Object)500);
            HashMap<String, String> header = new HashMap<String, String>(1);
            header.put("appId", syncConfig.getAppId());
            String result = HttpClientUtils.post(syncConfig.getMemberSyncUri(), header, body.toJSONString(), "application/json", "UTF-8", null, null);
            if (null == result) {
                logger.warn("load member by updateSerial and ecCode happened warn,result is null!");
                return false;
            }
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (jsonObject.containsKey((Object)"code") && null != (code = jsonObject.getInteger("code")) && TypeEnum.ErrorCode.OVER_LIMIT.getCode().equals(code)) {
                logger.info("over limit rate, result :{}", (Object)result);
                return false;
            }
            if (jsonObject.containsKey((Object)"success") && !jsonObject.getBoolean("success").booleanValue()) {
                logger.info("load member by updateSerial and ecCode fail , result :{}", (Object)result);
                return false;
            }
            if (jsonObject.containsKey((Object)"data")) {
                JSONArray jsonArray = jsonObject.getJSONArray("data");
                List memberList = JSON.parseArray((String)jsonArray.toJSONString(), Member.class);
                if (!Utils.checkCollection(memberList)) {
                    logger.info("load member by updateSerial and ecCode success,but result memberList is empty");
                    return true;
                }
                for (Member member : memberList) {
                    if (member.getLastUpdateStatus() <= memberLastUpdateSeq) continue;
                    memberLastUpdateSeq = member.getLastUpdateStatus();
                }
                DataSyncEntity memberEntity = new DataSyncEntity();
                boolean updateResult = this.dataEntityUpdate(memberEntity, TypeEnum.DataSyncType.MEMBER_SYNC, memberLastUpdateSeq, memberList);
                if (!updateResult) {
                    logger.warn("\u4e09\u65b9\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
                    return false;
                }
                if (memberList != null && memberList.size() >= 500) {
                    this.loadEsMemberByUpdateSerial(memberLastUpdateSeq, ecCode);
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.warn("load member by updateSerial and ecCode happened :{}", (Throwable)e);
            return false;
        }
    }

    protected final boolean sysAdminSync(Long seq) {
        long sysAdminLastUpdateSeq = 0L;
        try {
            Integer code;
            if (null == seq) {
                IncrementSyncEntity adminEntity = new IncrementSyncEntity();
                adminEntity.setTypeEnum(TypeEnum.IncrementSyncType.SYS_ADMIN);
                Object adminSeq = this.dataSyncServer.update(adminEntity);
                if (null == adminSeq) {
                    logger.warn("Sys_Admin Observer is empty");
                    return false;
                }
                sysAdminLastUpdateSeq = !Utils.checkLong((Long)adminSeq) ? 0L : (Long)adminSeq;
            } else {
                sysAdminLastUpdateSeq = seq;
            }
            HashMap<String, String> header = new HashMap<String, String>(1);
            header.put("appId", syncConfig.getAppId());
            JSONObject body = new JSONObject();
            body.put("lastUpdateStatus", (Object)sysAdminLastUpdateSeq);
            String result = HttpClientUtils.post(syncConfig.getEcmsAdminSyncUri(), header, body.toJSONString(), "application/json", "UTF-8", null, null);
            if (null == result) {
                logger.warn("load ECMS admin by appId happened warn,result is null!");
                return false;
            }
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (jsonObject.containsKey((Object)"code") && null != (code = jsonObject.getInteger("code"))) {
                if (TypeEnum.ErrorCode.OVER_LIMIT.getCode().equals(code)) {
                    logger.info("over limit rate, result :{}", (Object)result);
                    return false;
                }
                if (1 != code) {
                    logger.info("load ECMS admin by appId fail,result :{}", (Object)result);
                    return false;
                }
            }
            if (jsonObject.containsKey((Object)"data")) {
                JSONArray jsonArray = jsonObject.getJSONArray("data");
                List adminList = JSON.parseArray((String)jsonArray.toJSONString(), AdminInfo.class);
                if (!Utils.checkCollection(adminList)) {
                    logger.info("load ECMS admin by appId success,but result adminList is empty");
                    return true;
                }
                for (AdminInfo admin : adminList) {
                    if (admin.getLastUpdateStatus() <= sysAdminLastUpdateSeq) continue;
                    sysAdminLastUpdateSeq = admin.getLastUpdateStatus();
                }
                DataSyncEntity adminEntity = new DataSyncEntity();
                boolean updateResult = this.dataEntityUpdate(adminEntity, TypeEnum.DataSyncType.SYS_ADMIN_SYNC, sysAdminLastUpdateSeq, adminList);
                if (!updateResult) {
                    logger.warn("\u4e09\u65b9\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.warn("load ECMS admin by appId happened :{}", (Throwable)e);
            return false;
        }
    }

    protected final boolean companyAdminSync(Long seq, String ecCode) {
        long companyAdminLastUpdateSeq = 0L;
        try {
            Integer code;
            if (!Utils.checkString(ecCode)) {
                logger.info("load ECSS admin by ecCode happened warn,the param ecCode is null");
                return false;
            }
            if (null == seq) {
                IncrementSyncEntity<String> adminEntity = new IncrementSyncEntity<String>();
                adminEntity.setTypeEnum(TypeEnum.IncrementSyncType.COMPANY_ADMIN);
                adminEntity.setData(ecCode);
                Object adminSeq = this.dataSyncServer.update((IncrementSyncEntity)adminEntity);
                if (null == adminSeq) {
                    logger.warn("Company_Admin Observer is empty");
                    return false;
                }
                companyAdminLastUpdateSeq = !Utils.checkLong((Long)adminSeq) ? 0L : (Long)adminSeq;
            } else {
                companyAdminLastUpdateSeq = seq;
            }
            HashMap<String, String> header = new HashMap<String, String>(1);
            header.put("appId", syncConfig.getAppId());
            JSONObject body = new JSONObject();
            body.put("ecCode", (Object)ecCode);
            body.put("lastUpdateStatus", (Object)companyAdminLastUpdateSeq);
            String result = HttpClientUtils.post(syncConfig.getEcssAdminSyncUri(), header, body.toJSONString(), "application/json", "UTF-8", null, null);
            if (null == result) {
                logger.warn("load ECSS admin by ecCode happened warn,result is null!");
                return false;
            }
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (jsonObject.containsKey((Object)"code") && null != (code = jsonObject.getInteger("code"))) {
                if (TypeEnum.ErrorCode.OVER_LIMIT.getCode().equals(code)) {
                    logger.info("over limit rate, result :{}", (Object)result);
                    return false;
                }
                if (1 != code) {
                    logger.info("load ECSS admin by appId fail,result :{}", (Object)result);
                    return false;
                }
            }
            if (jsonObject.containsKey((Object)"data")) {
                JSONArray jsonArray = jsonObject.getJSONArray("data");
                List adminList = JSON.parseArray((String)jsonArray.toJSONString(), AdminInfo.class);
                if (!Utils.checkCollection(adminList)) {
                    logger.info("load ECSS admin by appId success,but result adminList is empty");
                    return true;
                }
                for (AdminInfo admin : adminList) {
                    if (admin.getLastUpdateStatus() <= companyAdminLastUpdateSeq) continue;
                    companyAdminLastUpdateSeq = admin.getLastUpdateStatus();
                }
                DataSyncEntity adminEntity = new DataSyncEntity();
                boolean updateResult = this.dataEntityUpdate(adminEntity, TypeEnum.DataSyncType.COMPANY_ADMIN_SYNC, companyAdminLastUpdateSeq, adminList);
                if (!updateResult) {
                    logger.warn("\u4e09\u65b9\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.warn("load ECSS admin by ecCode happened :{}", (Throwable)e);
            return false;
        }
    }

    protected final boolean companyOpen(String ecCode) {
        MsgEntity<String> msgEntity = new MsgEntity<String>();
        msgEntity.setTypeEnum(TypeEnum.MsgType.EC_OPEN);
        msgEntity.setData(ecCode);
        boolean success = this.msgServer.update(msgEntity);
        if (!success) {
            this.reportStatus(ecCode, TypeEnum.CompanyOpenStatus.FAIL.getCode());
        }
        CompanyFilterEntity entity = new CompanyFilterEntity();
        entity.setTypeEnum(TypeEnum.CompanyFilterType.COMPANY_CODES);
        Set ecCodes = (Set)this.companyFilterServer.update(entity);
        if (Utils.checkCollection(ecCodes) && ecCodes.contains(ecCode)) {
            this.reportStatus(ecCode, TypeEnum.CompanyOpenStatus.SUCCESS.getCode());
        }
        if (!(success = this.loadEsCompanyGroupByUpdateSerial(null, null))) {
            this.reportStatus(ecCode, TypeEnum.CompanyOpenStatus.FAIL.getCode());
        }
        if (!(success = this.loadEsCompanyByUpdateSerial(null, ecCode))) {
            this.reportStatus(ecCode, TypeEnum.CompanyOpenStatus.FAIL.getCode());
        }
        if (!(success = this.loadEsDeptByUpdateSerial(null, ecCode))) {
            this.reportStatus(ecCode, TypeEnum.CompanyOpenStatus.FAIL.getCode());
        }
        if (!(success = this.loadEsDeptByUpdateSerial(null, ecCode))) {
            this.reportStatus(ecCode, TypeEnum.CompanyOpenStatus.FAIL.getCode());
        } else {
            this.reportStatus(ecCode, TypeEnum.CompanyOpenStatus.SUCCESS.getCode());
        }
        return false;
    }

    protected final boolean companyClose(String ecCode) {
        MsgEntity<String> msgEntity = new MsgEntity<String>();
        msgEntity.setTypeEnum(TypeEnum.MsgType.EC_CLOSE);
        msgEntity.setData(ecCode);
        boolean success = this.msgServer.update(msgEntity);
        if (success) {
            this.reportStatus(ecCode, TypeEnum.CompanyOpenStatus.SUCCESS.getCode());
        } else {
            this.reportStatus(ecCode, TypeEnum.CompanyOpenStatus.FAIL.getCode());
        }
        return true;
    }

    protected final void reportStatus(String ecCode, Integer status) {
        JSONObject body = new JSONObject();
        body.put("ecCode", (Object)ecCode);
        body.put("status", (Object)status);
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put("appId", syncConfig.getAppId());
        try {
            HttpClientUtils.post(syncConfig.getReportUri(), header, body.toJSONString(), "application/json", "UTF-8", null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected final void loadEsData() {
        try {
            boolean success = this.loadEsCompanyGroupByUpdateSerial(null, null);
            if (!success) {
                return;
            }
            success = this.loadEsCompanyByUpdateSerial(null, null);
            if (!success) {
                return;
            }
            CompanyFilterEntity entity = new CompanyFilterEntity();
            entity.setTypeEnum(TypeEnum.CompanyFilterType.COMPANY_CODES);
            Set ecCodes = (Set)this.companyFilterServer.update(entity);
            if (Utils.checkCollection(ecCodes)) {
                for (String ecCode : ecCodes) {
                    this.loadEsDeptByUpdateSerial(null, ecCode);
                    this.loadEsMemberByUpdateSerial(null, ecCode);
                }
            }
        }
        catch (Exception e) {
            logger.warn("loadEsData task happened :{}", (Throwable)e);
            return;
        }
    }

    protected final boolean loginType(String loginType, String ecCode) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("loginType", (Object)loginType);
        jsonObject.put("ecCode", (Object)ecCode);
        MsgEntity<JSONObject> loginTypeEntity = new MsgEntity<JSONObject>();
        loginTypeEntity.setTypeEnum(TypeEnum.MsgType.AT_LOGIN_TYPE);
        loginTypeEntity.setData(jsonObject);
        boolean update = this.msgServer.update(loginTypeEntity);
        return update;
    }

    private boolean dataEntityUpdate(DataSyncEntity<?> entity, TypeEnum.DataSyncType dataSyncType, Long lastUpdateSeq, List entityList) {
        entity.setTypeEnum(dataSyncType);
        entity.setSeq(lastUpdateSeq);
        entity.setData(entityList);
        return this.dataSyncServer.update(entity);
    }
}

