/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ecdatasync.client;

import com.xdja.ecdatasync.client.DataSyncTask;
import com.xdja.ecdatasync.client.EcMqClient;
import com.xdja.ecdatasync.client.EsClient;
import com.xdja.ecdatasync.config.MsgConfig;
import com.xdja.ecdatasync.config.SyncConfig;
import com.xdja.ecdatasync.filter.CompanyFilter;
import com.xdja.ecdatasync.observable.CompanyFilterServer;
import com.xdja.ecdatasync.observable.DataSyncServer;
import com.xdja.ecdatasync.observable.MsgServer;
import com.xdja.ecdatasync.observer.BaseDataSyncObserver;
import com.xdja.ecdatasync.observer.MsgObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncClient {
    private static Logger logger = LoggerFactory.getLogger(SyncClient.class);
    private static SyncConfig syncConfig = null;
    private static MsgConfig msgConfig = null;
    private static EsClient esClient = null;
    private static SyncClient syncClient = null;

    private SyncClient() {
    }

    public static SyncClient getSyncClient() {
        if (null == esClient) {
            return null;
        }
        if (null == syncClient) {
            syncClient = new SyncClient();
        }
        return syncClient;
    }

    public static boolean init(SyncConfig sConfig) {
        if (null == syncConfig) {
            syncConfig = sConfig;
        }
        String logFlag = "SyncClient.init";
        logger.info("[lid:{}][{}] ecmsHost:{}, ecmsPort:{}, ecssHost:{}, ecssPort:{}", new Object[]{-1, logFlag, syncConfig.getEcmsHost(), syncConfig.getEcmsPort(), syncConfig.getEcssHost(), syncConfig.getEcssPort()});
        if (syncConfig.getSyncOpen() != 1) {
            logger.error("[lid:{}][{}] SyncClient init fail, SyncOpen is not Open!", (Object)-1, (Object)logFlag);
            return false;
        }
        esClient = EsClient.getEsClient(syncConfig);
        if (syncConfig.getTimingTaskOpen() == 1) {
            DataSyncTask task = new DataSyncTask();
            task.start(syncConfig);
        }
        logger.info("[lid:{}][{}] SyncClient init success!", (Object)-1, (Object)logFlag);
        return true;
    }

    public static boolean init(SyncConfig sConfig, MsgConfig mConfig) {
        if (null == syncConfig) {
            syncConfig = sConfig;
        }
        if (null == msgConfig) {
            msgConfig = mConfig;
        }
        String logFlag = "SyncClient.init";
        logger.info("[lid:{}][{}] ecmsHost:{}, ecmsPort:{}, ecssHost:{}, ecssPort:{}", new Object[]{-1, logFlag, syncConfig.getEcmsHost(), syncConfig.getEcmsPort(), syncConfig.getEcssHost(), syncConfig.getEcssPort()});
        if (syncConfig.getSyncOpen() != 1) {
            logger.error("[lid:{}][{}] SyncClient init fail, SyncOpen is not Open!", (Object)-1, (Object)logFlag);
            return false;
        }
        esClient = EsClient.getEsClient(syncConfig);
        if (syncConfig.getTimingTaskOpen() == 1) {
            DataSyncTask task = new DataSyncTask();
            task.start(syncConfig);
        }
        if (msgConfig.getMsgOpen() == 1) {
            EcMqClient ecMqClient = new EcMqClient();
            ecMqClient.init(syncConfig, msgConfig);
        }
        logger.info("[lid:{}][{}] SyncClient init success!", (Object)-1, (Object)logFlag);
        return true;
    }

    public static void registerCompanyFilter(CompanyFilter o) {
        CompanyFilterServer companyFilterServer = CompanyFilterServer.getCompanyFilterServer();
        companyFilterServer.registerObserver(o);
    }

    public static void registerDataSyncObserver(BaseDataSyncObserver o) {
        DataSyncServer dataSyncServer = DataSyncServer.getDataSyncServer();
        dataSyncServer.registerObserver(o);
    }

    public static void registerMsgObserver(MsgObserver o) {
        MsgServer msgServer = MsgServer.getMsgServer();
        msgServer.registerObserver(o);
    }

    public boolean companyGroupSyncByGroupId(Long groupId) {
        return esClient.loadEsCompanyGroupByUpdateSerial(null, groupId);
    }

    public boolean companyGroupSyncBySeq(Long seq) {
        return esClient.loadEsCompanyGroupByUpdateSerial(seq, null);
    }

    public boolean companyGroupSync() {
        return esClient.loadEsCompanyGroupByUpdateSerial(null, null);
    }

    public boolean companySyncByEcCode(String ecCode) {
        return esClient.loadEsCompanyByUpdateSerial(null, ecCode);
    }

    public boolean companySyncBySeq(Long seq) {
        return esClient.loadEsCompanyByUpdateSerial(seq, null);
    }

    public boolean companySync() {
        return esClient.loadEsCompanyByUpdateSerial(null, null);
    }

    public boolean deptSync(String ecCode) {
        return esClient.loadEsDeptByUpdateSerial(null, ecCode);
    }

    public boolean deptSyncBySeq(Long seq, String ecCode) {
        return esClient.loadEsDeptByUpdateSerial(seq, ecCode);
    }

    public boolean memberSync(String ecCode) {
        return esClient.loadEsMemberByUpdateSerial(null, ecCode);
    }

    public boolean memberSyncBySeq(Long seq, String ecCode) {
        return esClient.loadEsMemberByUpdateSerial(seq, ecCode);
    }

    public boolean sysAdminSync() {
        return esClient.sysAdminSync(null);
    }

    public boolean sysAdminSync(Long seq) {
        return esClient.sysAdminSync(seq);
    }

    public boolean companyAdminSync(String ecCode) {
        return esClient.companyAdminSync(null, ecCode);
    }

    public boolean companyAdminSync(Long seq, String ecCode) {
        return esClient.companyAdminSync(seq, ecCode);
    }
}

