/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ecdatasync.observable;

import com.xdja.ecdatasync.common.enums.TypeEnum;
import com.xdja.ecdatasync.entity.DataSyncEntity;
import com.xdja.ecdatasync.entity.IncrementSyncEntity;
import com.xdja.ecdatasync.observable.DataSyncObservable;
import com.xdja.ecdatasync.observer.BaseDataSyncObserver;
import com.xdja.ecdatasync.util.Utils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSyncServer
implements DataSyncObservable {
    private static Logger logger = LoggerFactory.getLogger(DataSyncServer.class);
    private BaseDataSyncObserver dataSyncObserver = null;
    private static Map<TypeEnum.DataSyncType, BaseDataSyncObserver> observerMap = new HashMap<TypeEnum.DataSyncType, BaseDataSyncObserver>();
    private static Map<TypeEnum.IncrementSyncType, BaseDataSyncObserver> IncrementMap = new HashMap<TypeEnum.IncrementSyncType, BaseDataSyncObserver>();
    private static DataSyncServer dataSyncServer = null;

    private DataSyncServer() {
    }

    public static DataSyncServer getDataSyncServer() {
        if (null == dataSyncServer) {
            dataSyncServer = new DataSyncServer();
        }
        return dataSyncServer;
    }

    @Override
    public final void registerObserver(BaseDataSyncObserver observer) {
        if (null != observer) {
            observerMap.put(observer.syncType, observer);
            IncrementMap.put(observer.incrementSyncType, observer);
        }
    }

    @Override
    public final boolean update(DataSyncEntity<?> entity) {
        this.dataSyncObserver = observerMap.get((Object)entity.getTypeEnum());
        if (this.dataSyncObserver == null) {
            logger.info("DataSyncObserver is empty");
            return false;
        }
        return this.dataSyncObserver.sync(entity);
    }

    @Override
    public final Long update(IncrementSyncEntity<?> entity) {
        this.dataSyncObserver = IncrementMap.get((Object)entity.getTypeEnum());
        if (this.dataSyncObserver == null) {
            logger.warn("DataSyncObserver is empty");
            return null;
        }
        Long getSeqResult = this.dataSyncObserver.getUpdateSerial((String)entity.getData());
        if (Utils.checkLong(getSeqResult)) {
            return getSeqResult;
        }
        return -1L;
    }
}

