/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ecdatasync.observable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.ecdatasync.common.enums.TypeEnum;
import com.xdja.ecdatasync.entity.MsgEntity;
import com.xdja.ecdatasync.model.AnTong;
import com.xdja.ecdatasync.observable.MsgObservable;
import com.xdja.ecdatasync.observer.MsgObserver;

public class MsgServer
implements MsgObservable {
    private static MsgObserver observer = null;
    private static MsgServer msgServer = null;

    private MsgServer() {
    }

    public static MsgServer getMsgServer() {
        if (null == msgServer) {
            msgServer = new MsgServer();
        }
        return msgServer;
    }

    @Override
    public boolean update(MsgEntity<?> entity) {
        if (entity.getTypeEnum().getCode().equalsIgnoreCase(TypeEnum.MsgType.EC_OPEN.getCode())) {
            return this.companyOpen((String)entity.getData());
        }
        if (entity.getTypeEnum().getCode().equalsIgnoreCase(TypeEnum.MsgType.EC_CLOSE.getCode())) {
            return this.companyClose((String)entity.getData());
        }
        if (entity.getTypeEnum().getCode().equalsIgnoreCase(TypeEnum.MsgType.AT_LOGIN_TYPE.getCode())) {
            AnTong anTong = (AnTong)JSONObject.toJavaObject((JSON)((JSON)entity.getData()), AnTong.class);
            return this.loginType(anTong.getLoginType(), anTong.getEcCode());
        }
        return false;
    }

    @Override
    public void registerObserver(MsgObserver o) {
        observer = o;
    }

    protected boolean companyOpen(String ecCode) {
        if (null != observer) {
            return observer.companyOpen(ecCode);
        }
        return false;
    }

    protected boolean companyClose(String ecCode) {
        if (null != observer) {
            return observer.companyClose(ecCode);
        }
        return false;
    }

    protected boolean loginType(String loginType, String ecCode) {
        if (null != loginType && null != ecCode) {
            return observer.loginType(loginType, ecCode);
        }
        return false;
    }
}

