/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ecdatasync.util;

import com.alibaba.fastjson.JSON;
import com.xdja.ecdatasync.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);
    private static String CHARSET = "charset=";
    private static HttpClient client = null;
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int SOCKET_TIMEOUT = 10000;

    public static Map post(String url, String charset) {
        return HttpClientUtils.post(url, charset, 5000, 10000, 0);
    }

    public static Map post(String url, String charset, int redo) {
        return HttpClientUtils.post(url, charset, 5000, 10000, redo);
    }

    public static Map post(String url, Map<String, String> headers, byte[] fileData, String charset, int redo) {
        return HttpClientUtils.post(url, headers, fileData, charset, 5000, (Integer)10000, redo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map post(String url, String charset, Integer connTimeout, Integer readTimeout, int redo) {
        CloseableHttpClient client = null;
        HttpPost post = new HttpPost(url);
        String result = "";
        boolean i = false;
        try {
            HttpResponse res;
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout.intValue());
            }
            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout.intValue());
            }
            post.setConfig(customReqConf.build());
            if (url.startsWith("https://")) {
                client = HttpClientUtils.createSSLInsecureClient();
                res = client.execute((HttpUriRequest)post);
            } else {
                client = HttpClientUtils.client;
                res = client.execute((HttpUriRequest)post);
            }
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)charset);
        }
        catch (Exception e) {
            logger.warn("httppost warn e:" + e);
        }
        finally {
            post.releaseConnection();
        }
        if (!Utils.checkString(result)) {
            return null;
        }
        return JSON.parseObject((String)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map post(String url, Map<String, String> headers, byte[] fileData, String charset, Integer connTimeout, Integer readTimeout, int redo) {
        HttpClient client = null;
        HttpPost post = new HttpPost(url);
        String result = "";
        int i = 0;
        try {
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    post.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (null != fileData && fileData.length > 0) {
                ByteArrayEntity entity = new ByteArrayEntity(fileData);
                post.setEntity((HttpEntity)entity);
            }
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout.intValue());
            }
            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout.intValue());
            }
            post.setConfig(customReqConf.build());
            client = HttpClientUtils.client;
            HttpResponse res = client.execute((HttpUriRequest)post);
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)charset);
        }
        catch (Exception e) {
            logger.warn("httppost warn e:" + e);
            if (redo > i) {
                HttpClientUtils.post(url, headers, fileData, charset, connTimeout, readTimeout, --redo);
            }
        }
        finally {
            post.releaseConnection();
        }
        if (!Utils.checkString(result)) {
            return null;
        }
        return JSON.parseObject((String)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String post(String url, Map<String, String> headers, String body, String mimeType, String charset, Integer connTimeout, Integer readTimeout) throws ConnectTimeoutException, SocketTimeoutException, Exception {
        HttpClient client = null;
        HttpPost post = new HttpPost(url);
        String result = "";
        try {
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    post.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)body)) {
                StringEntity entity = new StringEntity(body, ContentType.create((String)mimeType, (String)charset));
                post.setEntity((HttpEntity)entity);
            }
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null && connTimeout >= 0) {
                customReqConf.setConnectTimeout(connTimeout.intValue());
            } else {
                customReqConf.setConnectTimeout(10000);
            }
            if (readTimeout != null && readTimeout >= 0) {
                customReqConf.setSocketTimeout(readTimeout.intValue());
            } else {
                customReqConf.setSocketTimeout(10000);
            }
            post.setConfig(customReqConf.build());
            client = HttpClientUtils.client;
            HttpResponse res = client.execute((HttpUriRequest)post);
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)charset);
        }
        finally {
            post.releaseConnection();
        }
        return result;
    }

    public static Map get(String url, Map<String, String> headers, String charset) throws Exception {
        return HttpClientUtils.get(url, headers, charset, 5000, 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map get(String url, Map<String, String> headers, String charset, Integer connTimeout, Integer readTimeout) throws Exception {
        HttpClient client = null;
        HttpGet get = new HttpGet(url);
        String result = "";
        try {
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout.intValue());
            }
            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout.intValue());
            }
            get.setConfig(customReqConf.build());
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    get.addHeader(entry.getKey(), entry.getValue());
                }
            }
            client = HttpClientUtils.client;
            HttpResponse res = client.execute((HttpUriRequest)get);
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)charset);
        }
        finally {
            get.releaseConnection();
        }
        if (!Utils.checkString(result)) {
            return null;
        }
        return JSON.parseObject((String)result);
    }

    private static String getCharsetFromResponse(HttpResponse ressponse) {
        if (ressponse.getEntity() == null) {
            return null;
        }
        if (ressponse.getEntity().getContentType() == null) {
            return null;
        }
        if (ressponse.getEntity().getContentType().getValue() == null) {
            return null;
        }
        String contentType = ressponse.getEntity().getContentType().getValue();
        if (!contentType.contains(CHARSET)) {
            return null;
        }
        return contentType.substring(contentType.indexOf(CHARSET) + 8);
    }

    private static CloseableHttpClient createSSLInsecureClient() throws GeneralSecurityException {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier(){

            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }

            public void verify(String host, SSLSocket ssl) throws IOException {
            }

            public void verify(String host, X509Certificate cert) throws SSLException {
            }

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            }
        });
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    static {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(128);
        cm.setDefaultMaxPerRoute(128);
        client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }
}

