/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.identity.client;

import com.xdja.identity.bean.IdentityVerifyBean;
import com.xdja.identity.service.IdentityStatusService;
import com.xdja.identity.service.ResultBean;
import com.xdja.identity.service.StatusBean;
import com.xdja.identity.util.ConnFactory;
import com.xdja.identity.util.ResultCode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityStatusClient {
    private static Logger logger = LoggerFactory.getLogger(IdentityStatusClient.class);
    private String host;
    private int port;
    private static int TIME_OUT = 5000;
    private ConnFactory poolFactory;
    private static int MAX_TOTAL = 500;

    public IdentityStatusClient(String host, int port) {
        this(host, port, TIME_OUT, MAX_TOTAL);
    }

    public IdentityStatusClient(String host, int port, int maxTotal) {
        this(host, port, TIME_OUT, maxTotal);
    }

    public IdentityStatusClient(String host, int port, int maxTotal, int timeout) {
        this.host = host;
        this.port = port;
        TIME_OUT = timeout;
        MAX_TOTAL = maxTotal;
        this.init();
    }

    private void init() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(TIME_OUT);
        config.setMaxIdle(MAX_TOTAL);
        config.setMaxWaitMillis((long)TIME_OUT);
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        config.setNumTestsPerEvictionRun(10);
        this.poolFactory = new ConnFactory(config, this.host, this.port, TIME_OUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<IdentityVerifyBean> identityVerify(String appId, String appSecret, List<String> identitys) {
        TTransport transport = null;
        try {
            transport = this.poolFactory.getConnection();
        }
        catch (Exception e) {
            logger.warn("get connection from pool exception.", (Throwable)e);
            return null;
        }
        TCompactProtocol protocol = new TCompactProtocol(transport);
        IdentityStatusService.Client client = new IdentityStatusService.Client((TProtocol)protocol);
        try {
            ResultBean res = client.identityVerify(appId, appSecret, identitys);
            ArrayList<IdentityVerifyBean> arrayList = this.getIdentityVerifyBeans(res);
            return arrayList;
        }
        catch (TException e) {
            logger.warn("identityVerify interface call exception", (Throwable)e);
            ArrayList<IdentityVerifyBean> arrayList = null;
            return arrayList;
        }
        finally {
            if (transport != null) {
                this.poolFactory.releaseConnection(transport);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<IdentityVerifyBean> identityVerify(String appId, String appSecret, String sourceCode, List<String> identitys) {
        TTransport transport = null;
        try {
            transport = this.poolFactory.getConnection();
        }
        catch (Exception e) {
            logger.warn("get connection from pool exception.", (Throwable)e);
            return null;
        }
        TCompactProtocol protocol = new TCompactProtocol(transport);
        IdentityStatusService.Client client = new IdentityStatusService.Client((TProtocol)protocol);
        try {
            ResultBean res = client.identityAndSourceCodeVerify(appId, appSecret, sourceCode, identitys);
            ArrayList<IdentityVerifyBean> arrayList = this.getIdentityVerifyBeans(res);
            return arrayList;
        }
        catch (TException e) {
            logger.warn("identityVerify interface call exception", (Throwable)e);
            ArrayList<IdentityVerifyBean> arrayList = null;
            return arrayList;
        }
        finally {
            if (transport != null) {
                this.poolFactory.releaseConnection(transport);
            }
        }
    }

    private ArrayList<IdentityVerifyBean> getIdentityVerifyBeans(ResultBean res) {
        if (res.code == ResultCode.SUCCESS) {
            ArrayList<IdentityVerifyBean> result = new ArrayList<IdentityVerifyBean>();
            List<StatusBean> list = res.getData();
            if (list != null && list.size() > 0) {
                for (StatusBean status : list) {
                    result.add(new IdentityVerifyBean(status.getIdentity(), status.getStatus(), status.getEndTime(), status.getCode(), status.getMsg()));
                }
            }
            logger.info("identityVerify success! code:{}", (Object)res.getCode());
            return result;
        }
        logger.info("identityVerify fail! code:{}, msg:{}", (Object)res.getCode(), (Object)res.getMsg());
        return null;
    }
}

