/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.identity.util;

import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnFactory {
    private GenericObjectPool<TTransport> pool;
    private static Logger logger = LoggerFactory.getLogger(ConnFactory.class);

    public ConnFactory(GenericObjectPoolConfig config, String host, int port, int timeout) {
        ConnectionFactory objFactory = new ConnectionFactory(host, port, timeout);
        this.pool = new GenericObjectPool((PooledObjectFactory)objFactory, config);
    }

    public TTransport getConnection() throws Exception {
        return (TTransport)this.pool.borrowObject();
    }

    public void releaseConnection(TTransport transport) {
        this.pool.returnObject((Object)transport);
        if (this.pool.getNumIdle() >= this.pool.getNumActive()) {
            this.pool.clear();
        }
    }

    private class ConnectionFactory
    extends BasePooledObjectFactory<TTransport> {
        private String host;
        private int port;
        private int timeout;

        public ConnectionFactory(String host, int port, int timeout) {
            this.host = host;
            this.port = port;
            this.timeout = timeout;
        }

        public TTransport create() throws Exception {
            TFramedTransport transport = new TFramedTransport((TTransport)new TSocket(this.host, this.port, this.timeout));
            if (!transport.isOpen()) {
                transport.open();
            }
            return transport;
        }

        public PooledObject<TTransport> wrap(TTransport obj) {
            return new DefaultPooledObject((Object)obj);
        }

        public void activateObject(PooledObject<TTransport> p) throws Exception {
            TTransport transport = (TTransport)p.getObject();
            if (!transport.isOpen()) {
                transport.open();
            }
        }

        public boolean validateObject(PooledObject<TTransport> p) {
            TTransport transport = (TTransport)p.getObject();
            if (transport != null) {
                if (transport.isOpen()) {
                    return true;
                }
                try {
                    transport.open();
                }
                catch (TTransportException e) {
                    logger.warn("open transport exception in validateObject", (Throwable)e);
                }
            }
            return false;
        }

        public void passivateObject(PooledObject<TTransport> p) throws Exception {
            super.passivateObject(p);
        }

        public void destroyObject(PooledObject<TTransport> p) throws Exception {
            this.passivateObject(p);
            p.markAbandoned();
        }
    }
}

