/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.fastdfs.client.sdk.impl;

import com.xdja.fastdfs.client.sdk.FastDfsException;
import com.xdja.fastdfs.client.sdk.IFastDfsClient;
import com.xdja.fastdfs.client.sdk.impl.FastDfsClientConfig;
import com.xdja.fastdfs.client.sdk.impl.FileInfoImpl;
import com.xdja.fastdfs.client.sdk.impl.FileInputStreamBody;
import com.xdja.fastdfs.client.sdk.impl.Sequence;
import com.xdja.fastdfs.client.sdk.mac.MacUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class FastDfsClient
implements IFastDfsClient {
    private final transient Log logger = LogFactory.getLog(this.getClass());
    public static final String FASTDFS_CLIENT_CONFIG_FILE = "fdfs_client.properties";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final Pattern ERROR_MSG_PATTERN = Pattern.compile(".+\"errno\":(\\d+).+\"errmsg\":\"(.+)\".+");
    private static final Pattern UPLOAD_PATTERN = Pattern.compile(".+\"fileid\":\"(.+?)\".+");
    private static final Pattern INFO_PATTERN = Pattern.compile(".+\"create_time\":(\\d+).+\"file_size\":(\\d+).+\"source_ip_addr\":\"(.+?)\".+");
    private static final Pattern CRC32_PATTERN = Pattern.compile(".+\"crc32\":(\\d+).+");
    private final PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
    protected final HttpClient httpClient;
    private final FastDfsClientConfig config;

    public FastDfsClient() throws IOException {
        this.connectionManager.setMaxTotal(200);
        this.connectionManager.setDefaultMaxPerRoute(20);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
        this.config = new FastDfsClientConfig(FASTDFS_CLIENT_CONFIG_FILE);
    }

    public FastDfsClient(String configFilePath) throws IOException {
        this.connectionManager.setMaxTotal(200);
        this.connectionManager.setDefaultMaxPerRoute(20);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
        this.config = new FastDfsClientConfig(configFilePath);
    }

    public FastDfsClient(InputStream configFileInputStream) throws IOException {
        this.connectionManager.setMaxTotal(200);
        this.connectionManager.setDefaultMaxPerRoute(20);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
        this.config = new FastDfsClientConfig(configFileInputStream);
    }

    public FastDfsClient(Properties config) {
        this.connectionManager.setMaxTotal(200);
        this.connectionManager.setDefaultMaxPerRoute(20);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
        this.config = new FastDfsClientConfig(config);
    }

    private FastDfsException makeHttpException(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return new FastDfsException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), -1, "Nothing Recved");
        }
        String json = EntityUtils.toString((HttpEntity)response.getEntity()).trim();
        Matcher matcher = ERROR_MSG_PATTERN.matcher(json);
        if (!matcher.matches()) {
            return new FastDfsException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), -1, "Invalid Error Message Format: " + json);
        }
        int errno = Integer.parseInt(matcher.group(1));
        String errmsg = matcher.group(2);
        return new FastDfsException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), errno, errmsg);
    }

    private boolean hasError(HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        return statusCode != 200 && statusCode != 206;
    }

    private String createAuthParamter(String signData) {
        String sequence = Sequence.nextValue();
        String appid = this.config.getAppId();
        byte[] appkey = this.config.getAppKye();
        try {
            String mac = MacUtil.mac(appkey, appid + ":" + signData, sequence);
            StringBuffer parameters = new StringBuffer();
            parameters.append("?seqid=");
            parameters.append(sequence);
            parameters.append("&appid=");
            parameters.append(appid);
            parameters.append("&sign=");
            parameters.append(mac);
            String result = parameters.toString();
            this.logger.info((Object)("sign:[" + signData + "] -> [" + result + "]"));
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("\u751f\u6210\u7b7e\u540d\u5931\u8d25\u3002", e);
        }
    }

    private HttpPost createHttpPost(String postUrl) {
        HttpPost httpRequest = new HttpPost(postUrl);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.config.getNetworkTimeout()).setConnectTimeout(this.config.getConnectTimeout()).setConnectionRequestTimeout(10000).build();
        httpRequest.setConfig(requestConfig);
        return httpRequest;
    }

    private HttpGet createHttpGet(String url) {
        HttpGet httpRequest = new HttpGet(url);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.config.getNetworkTimeout()).setConnectTimeout(this.config.getConnectTimeout()).setConnectionRequestTimeout(10000).build();
        httpRequest.setConfig(requestConfig);
        return httpRequest;
    }

    private String getSignData(String url) {
        URL urlObject;
        try {
            urlObject = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String path = urlObject.getPath();
        return path;
    }

    @Override
    public String upload(byte[] data) throws IOException, FastDfsException {
        return this.upload(null, data);
    }

    @Override
    public String upload(String fileName, byte[] data) throws IOException, FastDfsException {
        return this.upload(fileName, new ByteArrayInputStream(data), data.length);
    }

    @Override
    public String upload(String fileName, File file) throws IOException, FastDfsException {
        return this.upload(fileName, new FileInputStream(file), file.length());
    }

    @Override
    public String upload(String fileName, InputStream is, long length) throws IOException, FastDfsException {
        String res;
        Matcher matcher;
        String fastDfsUrl = this.config.getUploadUrl();
        String signData = this.getSignData(fastDfsUrl);
        String postUrl = fastDfsUrl + this.createAuthParamter(signData);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("upload url:" + postUrl + " filename:" + fileName));
        }
        HttpPost httpRequest = this.createHttpPost(postUrl);
        if (fileName == null || fileName.trim().length() == 0) {
            fileName = "file";
        }
        Random rand = new Random();
        String boundary = "_" + rand.nextDouble() + "_BOUNDARY_" + rand.nextDouble() + "_";
        httpRequest.setHeader("filename", URLEncoder.encode(fileName, "utf-8"));
        httpRequest.setHeader(CONTENT_TYPE, "multipart/form-data; boundary=" + boundary);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("file", (ContentBody)new FileInputStreamBody(is, ContentType.APPLICATION_OCTET_STREAM, fileName, length));
        builder.setBoundary(boundary);
        HttpEntity entity = builder.build();
        httpRequest.setEntity(entity);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequest);
        HttpEntity responseEntity = response.getEntity();
        String result = EntityUtils.toString((HttpEntity)responseEntity);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("upload result:" + result));
        }
        if (!(matcher = UPLOAD_PATTERN.matcher(res = result.replace("\\/", "/").trim())).matches()) {
            throw new IOException("Invalid Response Format: " + res);
        }
        return matcher.group(1);
    }

    @Override
    public void append(String fid, InputStream is, long length) throws IOException, FastDfsException {
        String appendUrl = this.config.getAppendUrl(fid);
        String signData = this.getSignData(appendUrl);
        String postUrl = appendUrl + this.createAuthParamter(signData);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("append url:" + postUrl));
        }
        HttpPost httpRequest = this.createHttpPost(postUrl);
        httpRequest.setHeader(CONTENT_TYPE, APPLICATION_OCTET_STREAM);
        InputStreamEntity entity = new InputStreamEntity(is, length);
        httpRequest.setEntity((HttpEntity)entity);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequest);
        if (this.hasError(response)) {
            throw this.makeHttpException(response);
        }
        String result = EntityUtils.toString((HttpEntity)response.getEntity());
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("append result:" + result));
        }
    }

    @Override
    public void append(String fid, File file) throws IOException, FastDfsException {
        this.append(fid, new FileInputStream(file), file.length());
    }

    @Override
    public void append(String fid, byte[] data) throws IOException, FastDfsException {
        this.append(fid, new ByteArrayInputStream(data), data.length);
    }

    @Override
    public void download(String fid, OutputStream os) throws IOException, FastDfsException {
        this.download(fid, os, 0L);
    }

    @Override
    public void download(String fid, OutputStream os, long offset) throws IOException, FastDfsException {
        this.download(fid, os, offset, 0L);
    }

    @Override
    public void download(String fid, OutputStream os, long offset, long length) throws IOException, FastDfsException {
        String url = this.config.getDownloadUrl(fid);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("download url:" + url));
        }
        HttpGet get = this.createHttpGet(url);
        String range = null;
        range = length == 0L ? String.format("bytes=%d-", offset) : String.format("bytes=%d-%d", offset, offset + length - 1L);
        get.setHeader("Range", range);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
        if (this.hasError(response)) {
            throw this.makeHttpException(response);
        }
        response.getEntity().writeTo(os);
    }

    @Override
    public void delete(String fid) throws IOException, FastDfsException {
        HttpGet get;
        HttpResponse response;
        String deleteUrl = this.config.getDeleteUrl(fid);
        String signData = this.getSignData(deleteUrl);
        String url = deleteUrl + this.createAuthParamter(signData);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("delete url:" + url));
        }
        if (this.hasError(response = this.httpClient.execute((HttpUriRequest)(get = this.createHttpGet(url))))) {
            throw this.makeHttpException(response);
        }
        String result = EntityUtils.toString((HttpEntity)response.getEntity());
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("append result:" + result));
        }
    }

    @Override
    public IFastDfsClient.FileInfo info(String fid) throws IOException, FastDfsException {
        String res;
        Matcher matcher;
        HttpGet get;
        HttpResponse response;
        String url = this.config.getInfoUrl(fid);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("info url:" + url));
        }
        if (this.hasError(response = this.httpClient.execute((HttpUriRequest)(get = this.createHttpGet(url))))) {
            throw this.makeHttpException(response);
        }
        if (response.getEntity() == null) {
            throw new IOException("Invalid Response, No Entity");
        }
        String result = EntityUtils.toString((HttpEntity)response.getEntity());
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("info result:" + result));
        }
        if (!(matcher = INFO_PATTERN.matcher(res = result.trim())).matches()) {
            throw new IOException("Invalid Response: " + res);
        }
        long createTime = Long.parseLong(matcher.group(1));
        long fileSize = Long.parseLong(matcher.group(2));
        String srcAddr = matcher.group(3);
        FileInfoImpl ret = new FileInfoImpl(createTime, fileSize, srcAddr);
        return ret;
    }

    @Override
    public long crc32(String fid) throws FastDfsException, IOException {
        String res;
        Matcher matcher;
        HttpGet get;
        HttpResponse response;
        String url = this.config.getCrc32Url(fid);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("crc32 url:" + url));
        }
        if (this.hasError(response = this.httpClient.execute((HttpUriRequest)(get = this.createHttpGet(url))))) {
            throw this.makeHttpException(response);
        }
        String result = EntityUtils.toString((HttpEntity)response.getEntity());
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("crc32 result:" + result));
        }
        if (!(matcher = CRC32_PATTERN.matcher(res = result.trim())).matches()) {
            throw new IOException("Invalid Response: " + res);
        }
        return Long.parseLong(matcher.group(1));
    }
}

