/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.fastdfs.client.sdk.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FastDfsClientConfig {
    private static final Log LOGGER = LogFactory.getLog(FastDfsClientConfig.class);
    private static final Properties DEFAULT_CONFIG = new Properties();
    private String host;
    private String port;
    private String uploadUrl;
    private String appendUrl;
    private String downloadUrl;
    private String deleteUrl;
    private String infoUrl;
    private String crc32Url;
    private String appid;
    private byte[] appkey;
    private int connectTimeout = 3000;
    private int networkTimeout = 3000;
    private Properties properties;

    FastDfsClientConfig(String configFile) throws IOException {
        Properties prop = new Properties(DEFAULT_CONFIG);
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(configFile);
        if (in == null) {
            in = new FileInputStream(configFile);
        }
        prop.load(in);
        this.parserConfig(prop);
    }

    FastDfsClientConfig(InputStream configFile) throws IOException {
        Properties prop = new Properties(DEFAULT_CONFIG);
        prop.load(configFile);
        this.parserConfig(prop);
    }

    FastDfsClientConfig(Properties prop) {
        Properties properties = new Properties(DEFAULT_CONFIG);
        Enumeration<Object> keys = prop.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            properties.put(key, prop.get(key));
        }
        this.parserConfig(properties);
    }

    private void parserConfig(Properties prop) {
        this.properties = prop;
        this.host = prop.getProperty("fdfs.server.host");
        this.port = prop.getProperty("fdfs.server.port");
        this.uploadUrl = this.getProperty("fdfs.url.upload");
        this.appendUrl = this.getProperty("fdfs.url.append");
        this.downloadUrl = this.getProperty("fdfs.url.download");
        this.deleteUrl = this.getProperty("fdfs.url.delete");
        this.infoUrl = this.getProperty("fdfs.url.info");
        this.crc32Url = this.getProperty("fdfs.url.crc32");
        this.connectTimeout = this.getIntegerProperty("fdfs.client.connect_timeout", 2000);
        this.networkTimeout = this.getIntegerProperty("fdfs.client.network_timeout", 30000);
        this.appid = this.properties.getProperty("fdfs.client.appid");
        LOGGER.info((Object)("\u521d\u59cb\u5316FastDFS\u5ba2\u6237\u7aef\uff0c\u5c06\u8981\u8fde\u63a5FastDFS\u670d\u52a1\uff1a" + this.host + ":" + this.port));
        String keyProp = "fdfs.client.appkey";
        String appkeyHex = this.properties.getProperty(keyProp);
        if (appkeyHex == null) {
            throw new RuntimeException("\u7f3a\u5c11\u5e94\u7528\u79d8\u94a5\u53c2\u6570\uff1a" + keyProp);
        }
        try {
            this.appkey = Hex.decodeHex((char[])appkeyHex.toCharArray());
        }
        catch (DecoderException e) {
            throw new RuntimeException("\u5e94\u7528\u79d8\u94a5\u683c\u5f0f\u9519\u8bef\uff01", e);
        }
    }

    private String normalize(String property) {
        return property.replace("{HOST}", this.host).replace("{PORT}", this.port);
    }

    public String getProperty(String key) {
        String value = this.normalize(this.properties.getProperty(key));
        return value;
    }

    public Integer getIntegerProperty(String key) {
        return this.getIntegerProperty(key, null);
    }

    public Integer getIntegerProperty(String key, Integer def) {
        String value = this.properties.getProperty(key);
        return value == null ? def : Integer.valueOf(value);
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public String getAppendUrl(String fid) {
        return this.appendUrl.replace("{FID}", fid);
    }

    public String getDownloadUrl(String fid) {
        return this.downloadUrl.replace("{FID}", fid);
    }

    public String getDeleteUrl(String fid) {
        return this.deleteUrl.replace("{FID}", fid);
    }

    public String getInfoUrl(String fid) {
        return this.infoUrl.replace("{FID}", fid);
    }

    public String getCrc32Url(String fid) {
        return this.crc32Url.replace("{FID}", fid);
    }

    public int getNetworkTimeout() {
        return this.networkTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public String getAppId() {
        return this.appid;
    }

    public byte[] getAppKye() {
        return this.appkey;
    }

    static {
        try {
            DEFAULT_CONFIG.load(FastDfsClientConfig.class.getResourceAsStream("fdfs_client_default.properties"));
        }
        catch (IOException e) {
            LOGGER.error((Object)"\u52a0\u8f7dFastDFS\u5ba2\u6237\u7aef\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\u3002", (Throwable)e);
        }
    }
}

