/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.fastdfs.client.sdk.impl;

import com.xdja.fastdfs.client.sdk.IFastDfsClient;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public class FileInfoImpl
implements IFastDfsClient.FileInfo {
    private long fileSize;
    private Date createTime;
    private String srcAddr;
    private Map<String, Object> infos = Collections.emptyMap();

    FileInfoImpl(long createTime, long fileSize, String srcAddr) {
        this.setCreateTime(new Date(createTime * 1000L));
        this.setFileSize(fileSize);
        this.setSrcAddr(srcAddr);
    }

    FileInfoImpl(long createTime, long fileSize, String srcAddr, Map<String, Object> infos) {
        this(createTime, fileSize, srcAddr);
        if (infos != null) {
            this.infos = infos;
        }
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String toString() {
        return String.format("[CreateTime: %s, FileSize: %d, SrcAddr: %s]", this.createTime, this.fileSize, this.srcAddr);
    }

    @Override
    public String getSrcAddr() {
        return this.srcAddr;
    }

    void setSrcAddr(String srcAddr) {
        this.srcAddr = srcAddr;
    }

    @Override
    public Object getInfo(String key) {
        return this.infos.get(key);
    }
}

