/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.fastdfs.client.sdk.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public final class Sequence {
    private SimpleDateFormat SDF = new SimpleDateFormat("yyMMddHHmmss");
    private short value = Short.MIN_VALUE;
    private static final Sequence SEQUENCE = new Sequence();

    private Sequence() {
    }

    public static Sequence getInstance() {
        return SEQUENCE;
    }

    public static String nextValue() {
        return Sequence.getInstance().getNextValue();
    }

    public static String currentValue() {
        return Sequence.getInstance().getCurrentValue();
    }

    private synchronized short next() {
        if (this.value >= 0) {
            this.value = Short.MIN_VALUE;
        }
        this.value = (short)(this.value + 1);
        return this.value;
    }

    public String getNextValue() {
        return this.createValue(this.next());
    }

    private synchronized String createValue(short seq) {
        byte[] dateByte;
        byte[] seqByte = new byte[8];
        try {
            dateByte = Hex.decodeHex((char[])this.SDF.format(new Date()).toCharArray());
        }
        catch (DecoderException e) {
            throw new RuntimeException();
        }
        System.arraycopy(dateByte, 0, seqByte, 0, 6);
        Sequence.short2byte(seq, seqByte, 6);
        return Hex.encodeHexString((byte[])seqByte);
    }

    private static void short2byte(short n, byte[] buf, int offset) {
        buf[offset] = (byte)(n >> 8);
        buf[offset + 1] = (byte)n;
    }

    public String getCurrentValue() {
        return this.createValue(this.value);
    }
}

