/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.fastdfs.client.sdk.mac;

import com.xdja.fastdfs.client.sdk.mac.DesUtils;

public final class Pboc3DesMACUtils {
    public static final byte[] ZERO_IVC = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    public static byte[] calculatePboc3desMAC(byte[] data, byte[] key, byte[] icv) throws Exception {
        if (key == null || data == null) {
            throw new RuntimeException("data or key is null.");
        }
        if (key.length != 16) {
            throw new RuntimeException("key length is not 16 byte.");
        }
        byte[] leftKey = new byte[8];
        System.arraycopy(key, 0, leftKey, 0, 8);
        int dataLength = data.length;
        int blockCount = dataLength / 8 + 1;
        int lastBlockLength = dataLength % 8;
        byte[][] dataBlock = new byte[blockCount][8];
        for (int i = 0; i < blockCount; ++i) {
            int copyLength = i == blockCount - 1 ? lastBlockLength : 8;
            System.arraycopy(data, i * 8, dataBlock[i], 0, copyLength);
        }
        dataBlock[blockCount - 1][lastBlockLength] = -128;
        byte[] desXor = DesUtils.xOr(dataBlock[0], icv);
        for (int i = 1; i < blockCount; ++i) {
            byte[] des = DesUtils.encryptByDesCbc(desXor, leftKey);
            desXor = DesUtils.xOr(dataBlock[i], des);
        }
        desXor = DesUtils.encryptBy3DesCbc(desXor, key);
        return desXor;
    }
}

