/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.filetransfer.core.task;

import com.xdja.filetransfer.bean.FileBean;
import com.xdja.filetransfer.bean.OperateResult;
import com.xdja.filetransfer.bean.WaterMarkBean;
import com.xdja.filetransfer.core.FileTransferFactory;
import com.xdja.filetransfer.core.TransferInterface;
import com.xdja.filetransfer.enums.OperateEnum;
import com.xdja.filetransfer.enums.TypeEnum;
import com.xdja.filetransfer.exception.FileTransferException;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;

public class MultiTransferFileTask
implements Callable<List<OperateResult>> {
    private List<FileBean> fileBeans;
    private WaterMarkBean waterMarkBean;
    private String address;
    private TypeEnum typeEnum;
    private OperateEnum[] operateEnums;
    private String appId;
    private String appSecret;

    public MultiTransferFileTask(List<FileBean> fileBeans, WaterMarkBean waterMarkBean, String address, TypeEnum typeEnum, String appId, String appSecret, OperateEnum ... operateEnums) {
        this.fileBeans = fileBeans;
        this.waterMarkBean = waterMarkBean;
        this.address = address;
        this.typeEnum = typeEnum;
        this.operateEnums = operateEnums;
        this.appId = appId;
        this.appSecret = appSecret;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public TypeEnum getTypeEnum() {
        return this.typeEnum;
    }

    public void setTypeEnum(TypeEnum typeEnum) {
        this.typeEnum = typeEnum;
    }

    public OperateEnum[] getOperateEnums() {
        return this.operateEnums;
    }

    public void setOperateEnums(OperateEnum[] operateEnums) {
        this.operateEnums = operateEnums;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public List<FileBean> getFileBeans() {
        return this.fileBeans;
    }

    public void setFileBeans(List<FileBean> fileBeans) {
        this.fileBeans = fileBeans;
    }

    public WaterMarkBean getWaterMarkBean() {
        return this.waterMarkBean;
    }

    public void setWaterMarkBean(WaterMarkBean waterMarkBean) {
        this.waterMarkBean = waterMarkBean;
    }

    @Override
    public List<OperateResult> call() {
        if (this.typeEnum == null) {
            throw new FileTransferException("Type\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.address)) {
            throw new FileTransferException("\u6587\u4ef6\u8f6c\u6362\u670d\u52a1\u5730\u5740\u4e3a\u7a7a");
        }
        TransferInterface transferEngine = FileTransferFactory.getTransferEngine(this.typeEnum);
        return transferEngine.multiFileTransfer(this.fileBeans, this.waterMarkBean, this.address, this.appId, this.appSecret, this.operateEnums);
    }
}

