/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.filetransfer.core.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.filetransfer.bean.FileBean;
import com.xdja.filetransfer.bean.Location;
import com.xdja.filetransfer.bean.OperateParam;
import com.xdja.filetransfer.bean.OperateResult;
import com.xdja.filetransfer.bean.Step;
import com.xdja.filetransfer.bean.UploadBean;
import com.xdja.filetransfer.bean.WaterMarkBean;
import com.xdja.filetransfer.core.TransferInterface;
import com.xdja.filetransfer.enums.FileExtensionEnum;
import com.xdja.filetransfer.enums.OperateEnum;
import com.xdja.filetransfer.enums.OperateStatusEnum;
import com.xdja.filetransfer.exception.FileTransferException;
import com.xdja.filetransfer.util.FileUtil;
import com.xdja.filetransfer.util.HttpConnectionPoolUtil;
import com.xdja.filetransfer.util.HttpUtil;
import com.xdja.framework.commons.utils.http.HttpUtils;
import com.xdja.framework.commons.utils.http.ResponseWrap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WpsFileTransferV1
implements TransferInterface {
    private final Logger log = LoggerFactory.getLogger(WpsFileTransferV1.class);

    private WpsFileTransferV1() {
    }

    public static WpsFileTransferV1 getInstance() {
        return Instance.instance;
    }

    public String createSession(String address, String fileExtension, String fileAddress, String appId) {
        String uploadUrl = address + "/api/v1/cps/sessions" + "?file_extension=%s;";
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            uploadUrl = uploadUrl + "&appid=" + appId;
        }
        UploadBean uploadBean = new UploadBean();
        Location location = new Location();
        location.setAddress(fileAddress);
        uploadBean.setLocation(location);
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u521b\u5efasession\u8bf7\u6c42\u5730\u5740:{},param:{}", (Object)String.format(uploadUrl, fileExtension), (Object)JSON.toJSONString((Object)uploadBean));
        }
        String result = HttpUtil.post(String.format(uploadUrl, fileExtension)).header((Header)new BasicHeader("Content-Type", "application/json")).bodyString(JSON.toJSONString((Object)uploadBean)).execute().respBodyString();
        return this.checkResult(result);
    }

    public String createSession(String address, String fileExtension, File file, String appId) {
        return this.createSession(address, fileExtension, FileUtil.getBytesByFile(file), appId);
    }

    public String createSession(String address, String fileExtension, byte[] bytes, String appId) {
        String uploadUrl = address + "/api/v1/cps/sessions" + "?file_extension=%s;";
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            uploadUrl = uploadUrl + "&appid=" + appId;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u521b\u5efasession\u8bf7\u6c42\u5730\u5740:{}", (Object)String.format(uploadUrl, fileExtension));
        }
        ResponseWrap execute = HttpUtils.post((String)String.format(uploadUrl, fileExtension)).addHeader("Content-Type", "application/octet-stream").addBytes(bytes).execute();
        return this.checkResult(execute.getString());
    }

    private String checkResult(String result) {
        JSONObject jsonObject;
        String id;
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u521b\u5efasession\u8fd4\u56de\u7ed3\u679c:{}", (Object)result);
        }
        if (StringUtils.isBlank((CharSequence)(id = (jsonObject = JSONObject.parseObject((String)result)).getString("id")))) {
            this.log.error("\u521b\u5efasession\u5931\u8d25\uff0c\u672a\u8fd4\u56de\u6587\u4ef6ID");
            throw new FileTransferException("\u521b\u5efasession\u5931\u8d25\uff0c\u672a\u8fd4\u56de\u6587\u4ef6ID");
        }
        return id;
    }

    public boolean queryMonitorProcessing(String address, String id) {
        int errorTimes = 1;
        int queryTimes = 1;
        while (true) {
            try {
                while (true) {
                    long sleepTime;
                    if (Thread.currentThread().isInterrupted()) {
                        return false;
                    }
                    String status = this.queryMonitor(address, id);
                    if (StringUtils.isBlank((CharSequence)status)) {
                        this.log.error("\u68c0\u6d4bsession\u72b6\u6001\u5f02\u5e38\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0csessionId\uff1a{}", (Object)id);
                        throw new FileTransferException("\u68c0\u6d4bsession\u72b6\u6001\u5f02\u5e38\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                    }
                    if (OperateStatusEnum.ERROR.getStatus().equals(status)) {
                        this.log.error("\u68c0\u6d4bsession\u72b6\u6001\u5f02\u5e38\uff0cstatus\uff1a{}\uff0csessionId\uff1a{}", (Object)status, (Object)id);
                        throw new FileTransferException("\u68c0\u6d4bsession\u72b6\u6001\u5f02\u5e38\uff1a" + status);
                    }
                    if (OperateStatusEnum.PROCESSING.getStatus().equals(status)) {
                        return true;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("queryMonitorProcessing get \u7ed3\u679c\u4e3a:{} \u7b49\u5f85\u4e0b\u6b21\u7ee7\u7eed\u8f6c\u6362", (Object)status);
                    }
                    long l = sleepTime = 100 / queryTimes <= 1 ? 1L : (long)(100 / queryTimes);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("queryMonitorProcessing \u7ebf\u7a0b\u4f11\u7720:{} ms", (Object)sleepTime);
                    }
                    TimeUnit.MILLISECONDS.sleep(sleepTime);
                    ++queryTimes;
                }
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    throw new FileTransferException("\u7ebf\u7a0b\u88ab\u6253\u65ad");
                }
                if (errorTimes <= 3) {
                    this.log.error("\u7b2c{}\u6b21\u67e5\u8be2session\u72b6\u6001\u5f02\u5e38:{},\u7ee7\u7eed\u91cd\u8bd5,sessionId:{}", new Object[]{++errorTimes, e.getMessage(), id});
                    continue;
                }
                this.log.error("\u67e5\u8be2session\u72b6\u6001\u5f02\u5e38\u6b21\u6570\u4e3a:3 \uff0c\u67e5\u8be2\u5931\u8d25\uff0csessionId:{}", (Object)id, (Object)e);
                throw new FileTransferException("\u67e5\u8be2session\u72b6\u6001\u5f02\u5e38:" + e.getMessage(), e);
            }
            break;
        }
    }

    public boolean queryMonitorCompleted(String address, String id) {
        int errorTimes = 1;
        int queryTimes = 1;
        while (true) {
            try {
                while (true) {
                    long sleepTime;
                    if (Thread.currentThread().isInterrupted()) {
                        return false;
                    }
                    String status = this.queryMonitor(address, id);
                    if (OperateStatusEnum.ERROR.getStatus().equals(status) || OperateStatusEnum.OperateError.getStatus().equals(status)) {
                        this.log.error("\u68c0\u6d4bsession\u72b6\u6001\u5f02\u5e38\uff0cstatus\uff1a{}\uff0csessionId\uff1a{}", (Object)status, (Object)id);
                        throw new FileTransferException("\u68c0\u6d4bsession\u72b6\u6001\u5f02\u5e38:" + status);
                    }
                    if (OperateStatusEnum.COMPLETED.getStatus().equals(status)) {
                        return true;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("queryMonitorCompleted get \u7ed3\u679c\u4e3a:{} \u7b49\u5f85\u4e0b\u6b21\u7ee7\u7eed\u8f6c\u6362", (Object)status);
                    }
                    long l = sleepTime = 100 / queryTimes <= 1 ? 1L : (long)(100 / queryTimes);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("queryMonitorCompleted \u7ebf\u7a0b\u4f11\u7720:{} ms", (Object)sleepTime);
                    }
                    TimeUnit.MILLISECONDS.sleep(sleepTime);
                    ++queryTimes;
                }
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    throw new FileTransferException("\u7ebf\u7a0b\u88ab\u6253\u65ad");
                }
                if (errorTimes <= 3) {
                    this.log.error("\u7b2c{}\u6b21\u67e5\u8be2session\u662f\u5426\u5b8c\u6210\u72b6\u6001\u5f02\u5e38:{},\u7ee7\u7eed\u91cd\u8bd5,sessionId:{}", new Object[]{++errorTimes, e.getMessage(), id});
                    continue;
                }
                this.log.error("\u67e5\u8be2session\u662f\u5426\u5b8c\u6210\u72b6\u6001\u5f02\u5e38:{},sessionId:{}", (Object)e.getMessage(), (Object)id);
                throw new FileTransferException("\u67e5\u8be2session\u72b6\u6001\u5f02\u5e38:" + e.getMessage(), e);
            }
            break;
        }
    }

    public void operate(String address, String id, Object param) {
        String operateUrl = address + "/api/v1/cps/sessions/%s/operate";
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u5f00\u59cb\u8fdb\u884c\u64cd\u4f5c\u8f6c\u6362-url:{},param:{}", (Object)String.format(operateUrl, id), (Object)JSON.toJSONString((Object)param));
        }
        ResponseWrap execute = HttpUtils.post((String)String.format(operateUrl, id)).addJson(param).execute();
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u64cd\u4f5c\u8fd4\u56de\u72b6\u6001\u7801:{}", (Object)execute.getStatusCode());
        }
        if (200 != execute.getStatusCode()) {
            throw new FileTransferException("\u8f6c\u6362\u64cd\u4f5c\u5f02\u5e38\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + execute.getStatusCode());
        }
    }

    public String queryMonitor(String address, String id) throws IOException {
        String monitorUrl = address + "/api/v1/cps/sessions/%s/monitor";
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u67e5\u8be2session\u72b6\u6001-url:{}", (Object)String.format(monitorUrl, id));
        }
        String result = HttpConnectionPoolUtil.get(String.format(monitorUrl, id));
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u67e5\u8be2session\u72b6\u6001\u8fd4\u56de\u7ed3\u679c:{}", (Object)result);
        }
        JSONObject res = JSONObject.parseObject((String)result);
        return res.getString("status");
    }

    public String getContentAddress(String address, String id) {
        String contentUrl = address + "/api/v1/cps/sessions/%s/content";
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u5f00\u59cb\u83b7\u53d6\u8f6c\u6362\u540e\u7684\u5185\u5bb9-url:{}", (Object)String.format(contentUrl, id));
        }
        ResponseWrap responseWrap = HttpUtils.get((String)String.format(contentUrl, id)).execute();
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u8f6c\u6362\u540e\u7684\u8fd4\u56de\u7ed3\u679c:{}", (Object)responseWrap.getString());
        }
        JSONObject jsonObject = JSONObject.parseObject((String)responseWrap.getString());
        return jsonObject.getJSONObject("location").getString("address");
    }

    @Override
    public String fileTransferAddress(String fileId, String address, FileExtensionEnum fileExtensionEnum, String fileAddress, String appId, String appSecret, OperateEnum ... operateEnums) {
        String sessionId = this.createSession(address, fileExtensionEnum.getFileExtension(), fileAddress, appId);
        boolean isProcessing = this.queryMonitorProcessing(address, sessionId);
        if (isProcessing) {
            this.operate(address, sessionId, this.getOperateParam(operateEnums));
            if (this.queryMonitorCompleted(address, sessionId)) {
                return this.getContentAddress(address, sessionId);
            }
        }
        throw new FileTransferException("\u67e5\u8be2\u72b6\u6001\u5f02\u5e38\uff0c\u67e5\u8be2\u8d85\u65f6");
    }

    @Override
    public String fileTransferAddress(String fileId, String address, FileExtensionEnum fileExtensionEnum, byte[] bytes, String appId, String appSecret, OperateEnum ... operateEnums) {
        String id = this.createSession(address, fileExtensionEnum.getFileExtension(), bytes, appId);
        boolean isProcessing = this.queryMonitorProcessing(address, id);
        if (isProcessing) {
            this.operate(address, id, this.getOperateParam(operateEnums));
            boolean operateResult = this.queryMonitorCompleted(address, id);
            if (operateResult) {
                return this.getContentAddress(address, id);
            }
        }
        throw new FileTransferException("\u67e5\u8be2\u72b6\u6001\u5f02\u5e38\uff0c\u67e5\u8be2\u8d85\u65f6");
    }

    @Override
    public List<OperateResult> multiFileTransfer(List<FileBean> files, WaterMarkBean waterMarkBean, String address, String appId, String appSecret, OperateEnum ... operateEnums) {
        throw new FileTransferException("WPS V1\u7248\u672c\u63a5\u53e3\u4e0d\u652f\u6301\u6279\u91cf\u8f6c\u6362\u64cd\u4f5c");
    }

    @Override
    public String multiFileTransferCallBack(List<FileBean> files, WaterMarkBean waterMarkBean, String address, String callbackUrl, String appId, String appSecret, OperateEnum ... operateEnums) {
        throw new FileTransferException("WPS V1\u7248\u672c\u63a5\u53e3\u4e0d\u652f\u6301\u6279\u91cf\u8f6c\u6362\u64cd\u4f5c");
    }

    public byte[] getContent(String address, String id, long currentTime) {
        String contentUrl = address + "/api/v1/cps/sessions/%s/content" + "?location_address=stream";
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u5f00\u59cb\u83b7\u53d6\u8f6c\u6362\u540e\u7684\u5185\u5bb9-url:{}", (Object)String.format(contentUrl, id));
        }
        ResponseWrap responseWrap = HttpUtils.get((String)String.format(contentUrl, id)).execute();
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u8f6c\u6362\u540e\u7684\u5b57\u8282\u6570\u7ec4\u957f\u5ea6:{} byte", (Object)responseWrap.getBytes().length);
        }
        if (this.log.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            this.log.debug("\u8f6c\u6362\u8017\u65f6\uff1a{}s", (Object)((endTime - currentTime) / 1000L));
        }
        return responseWrap.getBytes();
    }

    @Override
    public byte[] fileTransfer(String fileId, String address, FileExtensionEnum fileExtensionEnum, String fileAddress, String appId, String appSecret, OperateEnum ... operateEnums) {
        long currentTime = System.currentTimeMillis();
        String sessionId = this.createSession(address, fileExtensionEnum.getFileExtension(), fileAddress, appId);
        if (this.queryMonitorProcessing(address, sessionId)) {
            this.operate(address, sessionId, this.getOperateParam(operateEnums));
            if (this.queryMonitorCompleted(address, sessionId)) {
                return this.getContent(address, sessionId, currentTime);
            }
        }
        throw new FileTransferException("\u67e5\u8be2\u72b6\u6001\u5f02\u5e38\uff0c\u67e5\u8be2\u8d85\u65f6");
    }

    @Override
    public byte[] fileTransfer(String fileId, String address, FileExtensionEnum fileExtensionEnum, byte[] bytes, String appId, String appSecret, OperateEnum ... operateEnums) {
        long currentTIme = System.currentTimeMillis();
        String id = this.createSession(address, fileExtensionEnum.getFileExtension(), bytes, appId);
        boolean isProcessing = this.queryMonitorProcessing(address, id);
        if (isProcessing) {
            this.operate(address, id, this.getOperateParam(operateEnums));
            boolean operateResult = this.queryMonitorCompleted(address, id);
            if (operateResult) {
                return this.getContent(address, id, currentTIme);
            }
        }
        throw new FileTransferException("\u67e5\u8be2\u72b6\u6001\u5f02\u5e38\uff0c\u67e5\u8be2\u8d85\u65f6");
    }

    private OperateParam getOperateParam(OperateEnum ... operateEnums) {
        OperateParam operateParam = OperateParam.create();
        if (operateEnums == null || operateEnums.length <= 0) {
            return operateParam.convertToPDFStep();
        }
        for (OperateEnum operateEnum : operateEnums) {
            operateParam.addStep(new Step(operateEnum.getOperate(), null));
        }
        return operateParam;
    }

    private static class Instance {
        private static final WpsFileTransferV1 instance = new WpsFileTransferV1();

        private Instance() {
        }
    }
}

