/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.filetransfer.core.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.filetransfer.bean.ViewFileBean;
import com.xdja.filetransfer.bean.ViewFileInfo;
import com.xdja.filetransfer.bean.ViewResult;
import com.xdja.filetransfer.bean.ViewReuqestBean;
import com.xdja.filetransfer.core.XViewInterface;
import com.xdja.filetransfer.exception.FileTransferException;
import com.xdja.filetransfer.util.HttpConnectionPoolUtil;
import com.xdja.filetransfer.util.SignatureUtil;
import com.xdja.framework.commons.utils.http.HttpUtils;
import com.xdja.framework.commons.utils.http.ResponseWrap;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WpsFileView
implements XViewInterface {
    private static final Logger log = LoggerFactory.getLogger(WpsFileView.class);

    private WpsFileView() {
    }

    public static WpsFileView getInstance() {
        return Instance.instance;
    }

    @Override
    public String viewFile(ViewFileBean viewFileBean, String address, String appId, String appSecret) throws InterruptedException {
        ViewResult viewResult;
        ResponseWrap execute;
        long startTime = System.currentTimeMillis();
        ViewReuqestBean viewReuqestBean = this.transferViewRequestParam(viewFileBean);
        String url = address + "/v2/view" + "?showcomments=" + viewFileBean.isShowComments();
        if (StringUtils.isNotBlank((CharSequence)appId) && StringUtils.isNotBlank((CharSequence)appSecret)) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("showcomments", String.valueOf(viewFileBean.isShowComments()));
            String signature = SignatureUtil.getSignature(param, appId, appSecret);
            url = url + "&appid=" + appId + "&signature=" + signature;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u6587\u4ef6\u9884\u89c8\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
            log.debug("\u6587\u4ef6\u9884\u89c8\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)viewReuqestBean));
        }
        if (200 != (execute = viewFileBean.isLocalFile() ? HttpUtils.post((String)url).newForm().addParamter("fileInfo", JSON.toJSONString((Object)viewReuqestBean)).addParamter("file", viewFileBean.getBytes(), ContentType.APPLICATION_OCTET_STREAM, viewFileBean.getFileName()).execute() : HttpUtils.post((String)url).addJson((Object)viewReuqestBean).execute()).getStatusCode()) {
            throw new FileTransferException("\u83b7\u53d6\u9884\u89c8\u5730\u5740\u5931\u8d25\uff0c\u8fd4\u56de\u72b6\u6001\u7801\u5f02\u5e38\uff1a" + execute.getStatusCode());
        }
        String result = execute.getString();
        if (StringUtils.isBlank((CharSequence)result)) {
            throw new FileTransferException("\u83b7\u53d6\u9884\u89c8\u5730\u5740\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u9884\u89c8\u5730\u5740\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        }
        if (0 == (viewResult = (ViewResult)JSON.parseObject((String)result, ViewResult.class)).getCode()) {
            if (log.isDebugEnabled()) {
                log.debug("\u672c\u6b21\u9884\u89c8\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - startTime));
            }
            return viewResult.getPath();
        }
        if (1 == viewResult.getCode()) {
            return this.viewFile(viewFileBean, address, appId, appSecret);
        }
        throw new FileTransferException("\u6839\u636e\u8fdc\u7a0b\u6587\u4ef6\u65b9\u5f0f\u83b7\u53d6\u9884\u89c8\u5730\u5740\u5931\u8d25\uff0c\u8fd4\u56decode\uff1a" + viewResult.getCode() + "message\uff1a" + viewResult.getMsg());
    }

    private String getViewUrl(ViewResult viewResult, long startTime, String statusUrl) throws InterruptedException {
        if (0 == viewResult.getCode()) {
            if (log.isDebugEnabled()) {
                log.debug("\u672c\u6b21\u9884\u89c8\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - startTime));
            }
            return viewResult.getPath();
        }
        if (1 == viewResult.getCode()) {
            return this.pollingQueryViewAddress(viewResult, startTime, statusUrl);
        }
        throw new FileTransferException("\u6839\u636e\u8fdc\u7a0b\u6587\u4ef6\u65b9\u5f0f\u83b7\u53d6\u9884\u89c8\u5730\u5740\u5931\u8d25\uff0c\u8fd4\u56decode\uff1a" + viewResult.getCode() + "message\uff1a" + viewResult.getMsg());
    }

    private ViewReuqestBean transferViewRequestParam(ViewFileBean viewFileBean) {
        ViewReuqestBean viewReuqestBean = new ViewReuqestBean();
        ViewFileInfo viewFileInfo = new ViewFileInfo();
        viewFileInfo.setUniqueId(viewFileBean.getFileId());
        if (viewFileBean.isLocalFile()) {
            viewFileInfo.setGetFileWay("localfile");
        } else {
            viewFileInfo.setGetFileWay("download");
            viewFileInfo.setUrl(viewFileBean.getFileUrl());
        }
        viewFileInfo.setFname(viewFileBean.getFileName());
        viewFileInfo.setSize(viewFileBean.getFileSize());
        viewFileInfo.setDownloadheader(viewFileBean.getFileDownloadHeader());
        viewFileInfo.setEnableCopy(viewFileBean.isEnableCopy());
        viewFileInfo.setEnablePrint(viewFileBean.isEnablePrint());
        viewFileInfo.setWatermark(viewFileBean.getWatermark());
        viewFileInfo.setWatermarkSetting(viewFileBean.getWatermarkSetting());
        viewFileInfo.setWatermarkType(viewFileBean.getWatermarkType());
        viewReuqestBean.setFileInfo3rd(viewFileInfo);
        return viewReuqestBean;
    }

    private String pollingQueryViewAddress(ViewResult viewResult, long startTime, String statusUrl) throws InterruptedException {
        TimeUnit.MILLISECONDS.sleep(viewResult.getWait());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("x-wps-host-replacement", "out");
        String result = HttpConnectionPoolUtil.get(statusUrl, map);
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u9884\u89c8\u5730\u5740\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        }
        if (StringUtils.isBlank((CharSequence)result)) {
            throw new FileTransferException("\u8f6e\u8be2\u83b7\u53d6\u9884\u89c8\u5730\u5740\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        ViewResult queryResult = (ViewResult)JSON.parseObject((String)result, ViewResult.class);
        return this.getViewUrl(queryResult, startTime, statusUrl);
    }

    private static class Instance {
        private static final WpsFileView instance = new WpsFileView();

        private Instance() {
        }
    }
}

