/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.filetransfer.util;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionPoolUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpConnectionPoolUtil.class);
    private static final int CONNECT_TIMEOUT = 3000;
    private static final int SOCKET_TIMEOUT = 3000;
    private static final int MAX_CONN = 100;
    private static final int Max_PRE_ROUTE = 100;
    private static final int MAX_ROUTE = 100;
    private static CloseableHttpClient httpClient;
    private static PoolingHttpClientConnectionManager manager;
    private static ScheduledExecutorService monitorExecutor;
    private static final Object syncLock;
    private static ResponseHandler<String> responseHandler;

    private static void setRequestConfig(HttpRequestBase httpRequestBase) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(3000).setConnectTimeout(3000).setCookieSpec("ignoreCookies").setSocketTimeout(3000).build();
        httpRequestBase.setConfig(requestConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient getHttpClient(String url) {
        String hostName = url.split("/")[2];
        int port = 80;
        if (hostName.contains(":")) {
            String[] args = hostName.split(":");
            hostName = args[0];
            port = Integer.parseInt(args[1]);
        }
        if (httpClient == null) {
            Object object = syncLock;
            synchronized (object) {
                if (httpClient == null) {
                    httpClient = HttpConnectionPoolUtil.createHttpClient(hostName, port);
                }
            }
        }
        return httpClient;
    }

    public static CloseableHttpClient createHttpClient(String host, int port) {
        PlainConnectionSocketFactory plainSocketFactory = PlainConnectionSocketFactory.getSocketFactory();
        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
        Registry registry = RegistryBuilder.create().register("http", (Object)plainSocketFactory).register("https", (Object)sslSocketFactory).build();
        manager = new PoolingHttpClientConnectionManager(registry);
        manager.setMaxTotal(100);
        manager.setDefaultMaxPerRoute(100);
        HttpHost httpHost = new HttpHost(host, port);
        manager.setMaxPerRoute(new HttpRoute(httpHost), 100);
        HttpRequestRetryHandler handler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException e, int i, HttpContext httpContext) {
                if (i > 3) {
                    logger.error("retry has more than 3 time, give up request");
                    return false;
                }
                if (e instanceof NoHttpResponseException) {
                    logger.error("receive no response from server, retry");
                    return true;
                }
                if (e instanceof SSLHandshakeException) {
                    logger.error("SSL hand shake exception");
                    return false;
                }
                if (e instanceof InterruptedIOException) {
                    logger.error("InterruptedIOException");
                    return false;
                }
                if (e instanceof UnknownHostException) {
                    logger.error("server host unknown");
                    return false;
                }
                if (e instanceof SSLException) {
                    logger.error("SSLException");
                    return false;
                }
                HttpClientContext context = HttpClientContext.adapt((HttpContext)httpContext);
                HttpRequest request = context.getRequest();
                return !(request instanceof HttpEntityEnclosingRequest);
            }
        };
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).setRetryHandler(handler).build();
    }

    public static String postJson(String url, Object o) {
        HttpPost httpPost = new HttpPost(url);
        String params = JSON.toJSONString((Object)o);
        HttpConnectionPoolUtil.setRequestConfig((HttpRequestBase)httpPost);
        httpPost.setEntity((HttpEntity)new StringEntity(params, ContentType.APPLICATION_JSON));
        try {
            return (String)HttpConnectionPoolUtil.getHttpClient(url).execute((HttpUriRequest)httpPost, responseHandler);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String get(String url) {
        HttpGet httpGet = new HttpGet(url);
        HttpConnectionPoolUtil.setRequestConfig((HttpRequestBase)httpGet);
        try {
            return (String)HttpConnectionPoolUtil.getHttpClient(url).execute((HttpUriRequest)httpGet, responseHandler);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String get(String url, Map<String, String> headers) {
        HttpGet httpGet = new HttpGet(url);
        HttpConnectionPoolUtil.setRequestConfig((HttpRequestBase)httpGet);
        if (headers != null) {
            for (String key : headers.keySet()) {
                httpGet.setHeader(key, headers.get(key));
            }
        }
        try {
            return (String)HttpConnectionPoolUtil.getHttpClient(url).execute((HttpUriRequest)httpGet, responseHandler);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void closeConnectionPool() {
        try {
            httpClient.close();
            manager.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        syncLock = new Object();
        responseHandler = new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws IOException {
                HttpEntity entity = response.getEntity();
                ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
                Charset charset = contentType.getCharset();
                return entity != null ? EntityUtils.toString((HttpEntity)entity, (Charset)charset) : null;
            }
        };
    }
}

