/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.framework.pro.central.environment;

import com.xdja.framework.pro.central.environment.ProCenterException;
import com.xdja.framework.pro.central.environment.PropertiesLoadHelper;
import com.xdja.framework.pro.central.util.ConfigUtil;
import com.xdja.framework.pro.central.util.EmptyUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.StringUtils;
import sun.security.pkcs.ParsingException;

public class BeforeConfigFileApplicationListener
implements EnvironmentPostProcessor,
Ordered {
    private List<PropertySourceLoader> propertySourceLoaders;
    private ResourceLoader resourceLoader;
    private final DeferredLog logger = new DeferredLog();
    private static final String SPRING_CONFIG_NAME = "spring.config.name";
    private static final String[] DEFAULT_CONFIG_NAMES = new String[]{"system", "db"};
    private static final String[] DEFAULT_REFRESH_FILE_NAME = new String[]{"system.properties"};

    public int getOrder() {
        return -2147483639;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Object[] configPaths;
        this.logger.switchTo(BeforeConfigFileApplicationListener.class);
        this.propertySourceLoaders = SpringFactoriesLoader.loadFactories(PropertySourceLoader.class, (ClassLoader)this.getClass().getClassLoader());
        this.resourceLoader = application.getResourceLoader();
        this.resourceLoader = this.resourceLoader != null ? this.resourceLoader : new DefaultResourceLoader(this.getClass().getClassLoader());
        this.loadProCenterConf(environment);
        String configPath = environment.getProperty("spring.config.location");
        if (EmptyUtil.isEmpty(configPath)) {
            if (File.separatorChar == '\\') {
                configPath = environment.getProperty("config.path.windows");
            } else if (File.separatorChar == '/') {
                configPath = environment.getProperty("config.path.linux");
            } else {
                throw new ProCenterException("system property File.separatorChar[" + File.separatorChar + "] not support");
            }
            if (EmptyUtil.isNotEmpty(configPath)) {
                this.setConfigLocationProperty(environment, configPath);
            }
        }
        if (EmptyUtil.isEmpty(configPath)) {
            this.logger.warn((Object)"\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u8def\u5f84\u3010file:./ \u6216 classpath:/\u3011");
            configPaths = new String[]{"file:./", "classpath:/"};
        } else {
            this.logger.warn((Object)("\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u8def\u5f84\u3010" + configPath + "\u3011"));
            if (configPath.contains("$")) {
                configPath = environment.resolvePlaceholders(configPath);
            }
            configPaths = StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)configPath));
        }
        Set<String> fileNames = this.fileNames((Environment)environment);
        System.out.println(Arrays.toString(configPaths));
        try {
            List<PropertySource<?>> list = this.loadPropertySource(new HashSet<Object>(Arrays.asList(configPaths)), fileNames);
            list.sort((o1, o2) -> {
                String name1 = o1.getName();
                String name2 = o2.getName();
                return name1.compareTo(name2);
            });
            this.addPropertySource(environment, list);
            String logBackPath = this.getLogBackPath((String[])configPaths);
            System.out.println(logBackPath);
            String[] refreshFileParentLocation = this.refreshFileParentLocation((Environment)environment, (String[])configPaths);
            this.setSystemAndLoggerProFilePath(environment, refreshFileParentLocation, logBackPath);
            ConfigUtil.evn = environment;
        }
        catch (IOException e) {
            throw new ProCenterException("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", e);
        }
    }

    private String[] refreshFileParentLocation(Environment environment, String[] configLocations) throws IOException {
        String refreshFileNames = environment.getProperty("config.enable-refresh-file-name");
        String[] refreshNameArray = EmptyUtil.isEmpty(refreshFileNames) ? DEFAULT_REFRESH_FILE_NAME : StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)refreshFileNames));
        ArrayList<String> list = new ArrayList<String>();
        HashSet<String> needRefreshPath = new HashSet<String>();
        for (String configPath : configLocations) {
            configPath = this.clearPath(configPath);
            for (String refreshName : refreshNameArray) {
                Resource resource = this.getResource(configPath + refreshName);
                if (resource == null || !resource.exists() || !resource.isFile()) continue;
                needRefreshPath.add(configPath);
            }
        }
        for (String refreshPath : needRefreshPath) {
            Resource resource = this.getResource(refreshPath);
            if (resource == null || !resource.exists()) continue;
            list.add(resource.getFile().getAbsolutePath());
        }
        return list.toArray(new String[0]);
    }

    private String getLogBackPath(String[] configPaths) throws IOException {
        for (String path : configPaths) {
            Resource resource = this.getResource((path = this.clearPath(path)) + "logback-spring.xml");
            if (resource == null || !resource.exists() || !resource.isFile()) continue;
            return resource.getFile().getAbsolutePath();
        }
        throw new ParsingException("cannot found logback-spring.xml");
    }

    private List<PropertySource<?>> loadPropertySource(Set<String> locations, Set<String> fileNames) throws IOException {
        LinkedList list = new LinkedList();
        for (PropertySourceLoader loader : this.propertySourceLoaders) {
            list.addAll(this.load(loader, locations, fileNames));
        }
        return list;
    }

    private List<PropertySource<?>> load(PropertySourceLoader loader, Set<String> locations, Set<String> fileNames) throws IOException {
        String[] fileExtensions = loader.getFileExtensions();
        HashSet<String> fullNames = new HashSet<String>();
        for (String ext : fileExtensions) {
            fullNames.addAll(this.fullNames(fileNames, ext));
        }
        LinkedList list = new LinkedList();
        for (String location : locations) {
            location = this.clearPath(location);
            for (String fullName : fullNames) {
                Resource resource = this.getResource(location + fullName);
                if (resource == null || !resource.exists() || !resource.isFile()) continue;
                List load = loader.load(fullName, resource);
                list.addAll(load);
            }
        }
        return list;
    }

    private Resource getResource(String location) {
        try {
            if (location.contains("*")) {
                throw new ProCenterException("location error [" + location + "] not support * ");
            }
            if (!location.startsWith("classpath:") && !location.startsWith("file:")) {
                location = "file:" + location;
            }
            return this.resourceLoader.getResource(location);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Set<String> fullNames(Set<String> fileNames, String ext) {
        HashSet<String> fullNames = new HashSet<String>();
        for (String fileName : fileNames) {
            fullNames.add(fileName + "." + ext);
        }
        return fullNames;
    }

    private Set<String> fileNames(Environment environment) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(Arrays.asList(DEFAULT_CONFIG_NAMES));
        result.addAll(this.fileNames(environment, "config.include-file-names"));
        result.addAll(this.fileNames(environment, "config.enable-refresh-file-name"));
        Set<String> evnConfigNames = this.evnConfigNames(environment);
        result.removeAll(evnConfigNames);
        return result;
    }

    private Set<String> fileNames(Environment environment, String key) {
        String[] names;
        String fileNames = environment.getProperty(key);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (EmptyUtil.isEmpty(fileNames)) {
            return result;
        }
        if (fileNames.contains("\\") || fileNames.contains("/")) {
            throw new ProCenterException("include file names error [\\ or /] not support!");
        }
        for (String name : names = StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)fileNames))) {
            if (name.startsWith("application")) continue;
            if (name.contains(".")) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            result.add(name);
        }
        return result;
    }

    private Set<String> evnConfigNames(Environment environment) {
        if (environment.containsProperty(SPRING_CONFIG_NAME)) {
            String value = environment.getProperty(SPRING_CONFIG_NAME);
            List<String> list = Arrays.asList(StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)(value != null ? environment.resolvePlaceholders(value) : "application"))));
            return new LinkedHashSet<String>(list);
        }
        return new LinkedHashSet<String>();
    }

    private void addPropertySource(ConfigurableEnvironment environment, Collection<PropertySource<?>> pss) {
        if (EmptyUtil.isEmpty(pss)) {
            return;
        }
        for (PropertySource<?> ps : pss) {
            environment.getPropertySources().addLast(ps);
        }
    }

    private String clearPath(String path) {
        if (path.contains(String.valueOf('\\'))) {
            path = path.replaceAll("\\\\", "/");
        }
        if (path.charAt(path.length() - 1) != '/') {
            path = path + '/';
        }
        return path;
    }

    private void setSystemAndLoggerProFilePath(ConfigurableEnvironment environment, String[] configDir, String logbackPath) {
        Properties properties = new Properties();
        properties.setProperty("logback.path", logbackPath);
        properties.setProperty("system.config.file.base.dir", StringUtils.arrayToDelimitedString((Object[])configDir, (String)","));
        environment.getPropertySources().addAfter("app.yml", (PropertySource)new PropertiesPropertySource("sys_and_log", properties));
    }

    private void setConfigLocationProperty(ConfigurableEnvironment environment, String configLocation) {
        String[] configPaths = StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)configLocation));
        StringBuilder locations = new StringBuilder();
        for (int i = 0; i < configPaths.length; ++i) {
            String configPath = configPaths[i];
            configPath = this.clearPath(configPath);
            if (i > 0) {
                locations.append(",");
            }
            locations.append(configPath).append("config").append('/');
        }
        Properties properties = new Properties();
        properties.setProperty("spring.config.location", locations.toString());
        environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("new_config_location", properties));
    }

    private void loadProCenterConf(ConfigurableEnvironment environment) {
        Resource resource = this.getResource("classpath:/app.yml");
        try {
            boolean exists;
            boolean bl = exists = resource != null && resource.exists();
            if (!exists) {
                throw new IllegalArgumentException("app.yml does not exists under classpath");
            }
            PropertySource<?> appYml = PropertiesLoadHelper.INSTANCE.load("app.yml", resource).get(0);
            MutablePropertySources propertySources = environment.getPropertySources();
            propertySources.addAfter("systemEnvironment", appYml);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("app.ymlload error", e);
        }
    }
}

