/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.framework.pro.central.listener;

import com.xdja.framework.pro.central.environment.ConfigurationPropertiesBeanCollector;
import com.xdja.framework.pro.central.listener.event.ConfRefreshEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;

public class ConfigurationPropertiesRebindListener
implements ApplicationContextAware,
ApplicationListener<ConfRefreshEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationPropertiesRebindListener.class);
    private ApplicationContext applicationContext;
    private static final String[] NEVER_REFRESH_BEAN_NAMES = new String[]{"com.zaxxer.hikari.HikariDataSource"};
    private ConfigurationPropertiesBeanCollector configurationPropertiesBeanCollector;

    public ConfigurationPropertiesRebindListener(ConfigurationPropertiesBeanCollector configurationPropertiesBeanCollector) {
        this.configurationPropertiesBeanCollector = configurationPropertiesBeanCollector;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ConfRefreshEvent confRefreshEvent) {
        if (this.applicationContext.equals(confRefreshEvent.getSource())) {
            this.rebind();
        }
    }

    private void rebind() {
        for (String s : this.configurationPropertiesBeanCollector.getBeanNames()) {
            this.rebind(s);
        }
    }

    private void rebind(String name) {
        if (!this.configurationPropertiesBeanCollector.getBeanNames().contains(name)) {
            return;
        }
        if (this.applicationContext != null) {
            try {
                Object bean = this.applicationContext.getBean(name);
                if (AopUtils.isAopProxy((Object)bean)) {
                    bean = this.getTargetObject(bean);
                }
                if (bean != null) {
                    if (this.getNeverRefreshAbleBeanNames().contains(bean.getClass().getName())) {
                        return;
                    }
                    this.applicationContext.getAutowireCapableBeanFactory().destroyBean(bean);
                    this.applicationContext.getAutowireCapableBeanFactory().initializeBean(bean, name);
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot rebind {}", (Object)name, (Object)e);
            }
        }
    }

    private Object getTargetObject(Object candidate) {
        try {
            return AopUtils.isAopProxy((Object)candidate) && candidate instanceof Advised ? ((Advised)candidate).getTargetSource().getTarget() : candidate;
        }
        catch (Exception var2) {
            throw new IllegalStateException("Failed to unwrap proxied object", var2);
        }
    }

    private Set<String> getNeverRefreshAbleBeanNames() {
        return new HashSet<String>(Arrays.asList(NEVER_REFRESH_BEAN_NAMES));
    }
}

