/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.framework.pro.central.listener;

import com.xdja.framework.pro.central.environment.PropertiesLoadHelper;
import com.xdja.framework.pro.central.environment.SeparateConst;
import com.xdja.framework.pro.central.listener.FileConfigChangeListener;
import com.xdja.framework.pro.central.listener.event.AfterConfRefreshEvent;
import com.xdja.framework.pro.central.listener.event.ConfRefreshEvent;
import com.xdja.framework.pro.central.listener.event.ConfigChangeEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class SeparateListener
implements SmartApplicationListener,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeparateListener.class);
    private Environment environment;
    private AtomicBoolean atomicBoolean = new AtomicBoolean(false);
    private ConfigurableApplicationContext applicationContext;

    public boolean supportsEventType(Class<? extends ApplicationEvent> aClass) {
        return aClass == ConfigChangeEvent.class || aClass == ApplicationReadyEvent.class;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        this.environment = (Environment)applicationContext.getBean(Environment.class);
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof ApplicationReadyEvent) {
            FileConfigChangeListener listener = new FileConfigChangeListener(this.environment.getProperty("system.config.file.base.dir"), new RefreshAbleConfFileFilter(this.environment.getProperty("config.enable-refresh-file-name", "system.properties")), this.refreshIntervalSeconds(), this.applicationContext);
            try {
                listener.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.atomicBoolean.compareAndSet(false, true);
            LOGGER.info("++++++++ Spring started +++++++++++");
        }
        if (!this.atomicBoolean.get()) {
            return;
        }
        if (applicationEvent instanceof ConfigChangeEvent) {
            Object source = applicationEvent.getSource();
            try {
                File file = (File)source;
                if (!this.isValidFileNameForRefresh(file.getName())) {
                    return;
                }
                List<PropertySource<?>> propertySources = PropertiesLoadHelper.INSTANCE.loadProperties(file);
                ConfigurableEnvironment evn = (ConfigurableEnvironment)this.environment;
                MutablePropertySources allEnvPro = evn.getPropertySources();
                for (PropertySource<?> propertySource : propertySources) {
                    String name = propertySource.getName();
                    if (allEnvPro.contains(name)) {
                        allEnvPro.replace(propertySource.getName(), propertySource);
                        continue;
                    }
                    allEnvPro.addBefore("sys_and_log", propertySource);
                }
                this.applicationContext.publishEvent((ApplicationEvent)new ConfRefreshEvent(this.applicationContext));
                this.applicationContext.publishEvent((ApplicationEvent)new AfterConfRefreshEvent(this.applicationContext));
            }
            catch (Exception e) {
                LOGGER.error("\u91cd\u65b0\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25:", (Throwable)e);
            }
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private long refreshIntervalSeconds() {
        long defaultSeconds = 5L;
        String property = this.environment.getProperty("config.file-refresh-interval", "5");
        if (property == null || property.trim().length() == 0) {
            return defaultSeconds;
        }
        for (char character : property.toCharArray()) {
            if (Character.isDigit(character)) continue;
            return defaultSeconds;
        }
        long l = Long.parseLong(property);
        return l < 1L ? 1L : l;
    }

    private boolean isValidFileNameForRefresh(String fileName) {
        if (!fileName.contains(".")) {
            return false;
        }
        String expression = fileName.substring(fileName.indexOf("."));
        if (!SeparateConst.expression(expression)) {
            return false;
        }
        String name = fileName.substring(0, fileName.lastIndexOf("."));
        return !name.startsWith("application");
    }

    private static class RefreshAbleConfFileFilter
    implements FileFilter {
        private Set<String> enableRefreshFileName = new HashSet<String>();
        private String dbFileName;

        RefreshAbleConfFileFilter(String enableRefreshFileName) {
            Set set = StringUtils.commaDelimitedListToSet((String)enableRefreshFileName);
            for (String s : set) {
                String trim = s.trim();
                this.enableRefreshFileName.add(trim);
            }
            this.dbFileName = "db.";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return this.enableRefreshFileName.contains(name) && !name.startsWith(this.dbFileName);
        }
    }
}

