package com.xdja.update;

import android.support.annotation.NonNull;

import com.xdja.update.bean.CheckResult;
import com.xdja.update.model.VersionConfigParentNodeInfo;
import com.xdja.update.model.VersionParentNodeInfo;

/**
 * <b>Description: 检测升级回调接口定义</b>
 * Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/10/17 11:43.
 */
public interface CheckCallback {
    /**
     * 正在进行升级检测
     */
    void onChecking();

    /**
     * 检测升级结果回调接口
     *
     * @param checkResult 检测结果对象{@link CheckResult}
     */
    void onCheckError(@NonNull VersionUpdateResult checkResult);

    void onCheckSuccess(VersionConfigParentNodeInfo versionConfigParentNodeInfo);

}
