package com.xdja.update;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;

import com.xdja.update.model.VersionConfigParentNodeInfo;
import com.xdja.update.model.VersionConfigSubNodeInfo;
import com.xdja.update.model.VersionParentNodeInfo;

import java.io.File;
import java.util.ArrayList;

/**
 * <b>Description: 检测升级任务</b>
 * Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/10/17 11:41.
 */
public class CheckTask extends AsyncTask<String, Integer, VersionUpdateResult> {

    /**
     * The constant TAG.
     */
    public static final String TAG = CheckTask.class.getSimpleName();

    @SuppressLint("StaticFieldLeak")
    @NonNull
    private final Context cxt;

    @NonNull
    private CheckCallback checkCallback;

    private VersionConfigParentNodeInfo versionConfigParentNodeInfo;
    private VersionParentNodeInfo versionParentNodeInfo;
    private VersionUpdateManager versionUpdateManager;
    private String fileDir;
    private String deviceId;

    /**
     * Instantiates a new Check task.
     *
     * @param context  the context
     * @param callback the callback
     */
    public CheckTask(@NonNull Context context, @NonNull CheckCallback callback) {
        this(context, null, callback);
    }

    public CheckTask(@NonNull Context context, String deviceId, @NonNull CheckCallback callback) {
        this.cxt = context.getApplicationContext();
        this.checkCallback = callback;
        this.deviceId = deviceId;
        versionUpdateManager = VersionUpdateManager.getInstance(cxt);
        fileDir = cxt.getFilesDir().getAbsolutePath();
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        this.checkCallback.onChecking();
    }

    @SuppressWarnings("ConstantConditions")
    @Override
    protected VersionUpdateResult doInBackground(String... params) {
        VersionUpdateResult versionUpdateResult = new VersionUpdateResult();
        try {

            //创建本地版本文件  将assets目录下的ClientVer.xml拷贝到应用私有目录files路径下面
            VersionUpdateResult createLocalFileResult = versionUpdateManager.createLocalVersionInfo(fileDir + "/ClientVer.xml");

            if (createLocalFileResult.isError()) {

                return createLocalFileResult;

            }
            // 解析本地文件
            VersionUpdateResult parseLocalVersionInfoResult = versionUpdateManager.parseLocalVersionInfo(fileDir + "/ClientVer.xml");

            if (parseLocalVersionInfoResult.isError()) {

                return parseLocalVersionInfoResult;

            }
            // 修正记录的版本升级列表，如果版本相等不修正，若不等就删除最后一个节点
            String verName = "";
            try {
                //获取版本信息
                verName = cxt.getPackageManager().getPackageInfo(cxt.getPackageName(), 0).versionName;

            } catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                Log.d(TAG, "versionUpdateResult" + e.getMessage());
                versionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Parse_Version_Name_Failed);
                return versionUpdateResult;
            }

            //更新版本文件
            VersionUpdateResult updateVersionXmlFileResult = versionUpdateManager.updateVersionXmlFile(verName, (VersionParentNodeInfo) parseLocalVersionInfoResult.getData());

            if (updateVersionXmlFileResult.isError()) {

                return updateVersionXmlFileResult;

            }
            //获取请求检查版本的xml字符Buffer
            StringBuffer checkVer = versionUpdateManager.getCheckUpdateXmlStr(deviceId, verName, (VersionParentNodeInfo) parseLocalVersionInfoResult.getData());


            //获取升级服务器数据结构bean
            VersionParentNodeInfo versionParentNodeInfo = (VersionParentNodeInfo) parseLocalVersionInfoResult.getData();

            //判断升级服务IP是否为空
            if (TextUtils.isEmpty(versionParentNodeInfo.getServerIp())) {
                versionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Version_Update_ServerIp_Empty);
                return versionUpdateResult;
            }
            //判断升级服务端口是否为空
            if (TextUtils.isEmpty(versionParentNodeInfo.getServerPort())) {
                versionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Version_Update_ServerPort_Empty);
                return versionUpdateResult;
            }

            UpdateSocket updateSocket = new UpdateSocket(versionParentNodeInfo.getServerIp(), Integer.parseInt(versionParentNodeInfo.getServerPort()));

            //连接升级服务返回值
            int connectResultCode = updateSocket.connect();

            if (connectResultCode != 0) {

                versionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Connect_Update_Server_Failed);
                return versionUpdateResult;
            }
            //发送检查更新服务数据返回值
            connectResultCode = updateSocket.sendData(checkVer.toString());

            if (connectResultCode != 0) {
                versionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Send_Update_Data_Failed);
                return versionUpdateResult;

            }
            byte[] result = updateSocket.recvData();

            if (result == null) {
                versionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Receive_Update_Date_Time_Out);
                Log.d(TAG, "checkVersionTask: updateSocket.recvData() result is :--->" + result);
                return versionUpdateResult;

            } else {

                connectResultCode = versionUpdateManager.parseVersionUpdateReceiveData(result);

                //解析升级返回结果
                VersionUpdateResult parseCheckUpdateResResult = versionUpdateManager.parseCheckUpdateRes(updateSocket, connectResultCode);

                versionUpdateResult.setResultCode(parseCheckUpdateResResult.getResultCode());

                //把本地升级配置信息抛到上层  文件下载时需要用到配置信息
                versionUpdateResult.setData(parseLocalVersionInfoResult.getData());

                Log.d(TAG, "升级服务返回信息：--->" + versionUpdateResult.getData());

                if (updateSocket != null) {
                    updateSocket.close();
                    updateSocket = null;
                }
                return versionUpdateResult;
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            versionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Send_Update_Data_Failed);
            Log.d(TAG, "VersionUpdateError :--->" + ex.getMessage());
            return versionUpdateResult;
        }
    }

    @Override
    protected void onPostExecute(VersionUpdateResult result) {
        super.onPostExecute(result);
        VersionUpdateResult tempVersionUpdateResult = result;
        versionParentNodeInfo = (VersionParentNodeInfo) tempVersionUpdateResult.getData();
        if (versionParentNodeInfo == null) {
            // 解析本地文件
            VersionUpdateResult parseLocalVersionInfoResult = versionUpdateManager.parseLocalVersionInfo(fileDir + "/ClientVer.xml");
            versionParentNodeInfo = (VersionParentNodeInfo) parseLocalVersionInfoResult.getData();
        }
        if (tempVersionUpdateResult.isError()) {
            //toto 检测更新错误或无新版本升级
            Log.i(TAG, tempVersionUpdateResult.getMessage(cxt));
            checkCallback.onCheckError(tempVersionUpdateResult);
            return;
        } else {
            //有新版本升级
            File file = new File(fileDir + "/update_s.xml");
            File tempFile = new File(fileDir + "/update_temp.xml");
            VersionConfigParentNodeInfo update_s_node_info = null;
            VersionConfigParentNodeInfo update_temp_node_info = null;
            // 解析升级配置信息
            VersionUpdateResult parseConfigInfoResult = versionUpdateManager.parseConfigInfo("update_s.xml");
            if (parseConfigInfoResult.isError()) {
                // 删除update_s.xml文件
                file.delete();
                Log.i(TAG, parseConfigInfoResult.getMessage(cxt));
                checkCallback.onCheckError(parseConfigInfoResult);
                return;
            } else {
                update_s_node_info = (VersionConfigParentNodeInfo) parseConfigInfoResult.getData();
            }
            //最新检测升级结果与之前的升级结果对比
            if (tempFile.exists()) {
                VersionUpdateResult parseTempInfoResult = versionUpdateManager.parseConfigInfo("update_temp.xml");
                if (parseTempInfoResult.isError()) {
                    Log.i(TAG, parseTempInfoResult.getMessage(cxt));
                    tempFile.delete();
                    checkCallback.onCheckError(parseTempInfoResult);
                    return;
                } else {
                    update_temp_node_info = (VersionConfigParentNodeInfo) parseTempInfoResult.getData();
                    if (update_s_node_info.getDate().equals(update_temp_node_info.getDate())
                            //如果更新信息一致可以断点续传，不更改更新信息
                            && update_s_node_info.getCheckCode().equals(update_temp_node_info.getCheckCode())
                            && update_s_node_info.getComment().equals(update_temp_node_info.getComment())
                            && update_s_node_info.getVersion().equals(update_temp_node_info.getVersion())) {
                        versionConfigParentNodeInfo = update_s_node_info;
                    } else {
                        //更新结果有变动，改为最新检测结果
                        versionConfigParentNodeInfo = update_temp_node_info;
                        file.delete();
                        tempFile.renameTo(file);

                    }
                }
                VersionUpdateResult tempParseConfigInfoResult = versionUpdateManager.parseConfigInfo("update_s.xml");
                if (tempParseConfigInfoResult.isError()) {
                    // 删除update_s.xml文件
                    file.delete();
                    Log.i(TAG, parseConfigInfoResult.getMessage(cxt));
                    checkCallback.onCheckError(parseConfigInfoResult);
                    return;
                }
            } else {
                versionConfigParentNodeInfo = update_s_node_info;
            }
            // 解决断点续传停止后，跨版本无法升级问题 end
            checkCallback.onCheckSuccess(versionConfigParentNodeInfo);
        }
    }
}