package com.xdja.update;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.xdja.update.enums.DownLoadFileError;

/**
 * <b>Description: 文件下载回调接口定义</b>
 * Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/11/1 16:41.
 */
public interface DownloadCallback {

    /**
     * 下载开始
     *
     */
    void onStart();

    /**
     * 下载进度更新回调接口
     *
     */
    void onProgress(int progress);

    /**
     * 下载已经停止
     *
     */
    void onStop();

    /**
     * 下载发生错误
     *
     * @param error 错误信息
     * @param ex       异常对象
     */
    void onError( @NonNull String error,Exception ex);

    /**
     * 下载完成
     *
     * @param filePath 文件完整路径（如：升级文件的下载文件夹路径 + fileId +".apk"）
     */
    void onComplete( @NonNull String filePath);

    /**
     * 设置升级文件的下载文件夹路径
     *
     * @return 升级文件的下载文件夹路径
     */
    @NonNull
    String downloadDir();
}
