package com.xdja.update;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;

import com.xdja.update.bean.CheckResult;
import com.xdja.update.enums.DownLoadFileError;
import com.xdja.update.model.VersionConfigParentNodeInfo;
import com.xdja.update.model.VersionConfigSubNodeInfo;
import com.xdja.update.model.VersionParentNodeInfo;
import com.xdja.update.utils.EncryptUtils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;

/**
 * <b>Description: 文件下载任务</b>
 * Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/11/1 16:33.
 */
public class DownloadTask extends AsyncTask<String, Integer, Boolean> {

    /**
     * The constant TAG.
     */
    public static final String TAG = DownloadTask.class.getSimpleName();
    /**
     * The constant BUFFER_UNIT.
     */
    public static final int BUFFER_UNIT = 1024 * 512;
    /**
     * The constant DEFAULT_BOUNDARY.
     */
    public static final String DEFAULT_BOUNDARY = "----7d4261b4f3";

    private DownloadCallback callback;

    private Handler mainHandler;

    private boolean isStoped = false;
    private UpdateSocket updateSocket;
    private Context context;
    private VersionConfigParentNodeInfo versionConfigParentNodeInfo;
    private ArrayList<VersionConfigSubNodeInfo> fileList;
    private String fileDir;
    private Integer progress;
    private File tfile;
    private VersionUpdateManager versionUpdateManager;
    private VersionParentNodeInfo versionParentNodeInfo;

    /**
     * Instantiates a new Download task.
     *
     * @param versionConfigParentNodeInfo the file
     * @param callback                    the callback
     */
    public DownloadTask(@NonNull Context context,
                        @NonNull VersionConfigParentNodeInfo versionConfigParentNodeInfo,
                        @NonNull DownloadCallback callback) {
        this.context = context;
        this.versionConfigParentNodeInfo = versionConfigParentNodeInfo;
        this.callback = callback;
        this.mainHandler = new Handler(Looper.getMainLooper());
        fileDir = context.getFilesDir().getAbsolutePath();
        versionUpdateManager = VersionUpdateManager.getInstance(context);
        fileList = versionConfigParentNodeInfo.getVersionConfigSubNodeInfos();
    }

    /**
     * Stop.
     */
    public synchronized void stop() {
        isStoped = true;
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        this.callback.onStart();
    }

    @Override
    protected Boolean doInBackground(String... params) {
        try {
            int nres = -1;
            //获取升级服务器数据结构bean
            // 解析本地文件
            VersionUpdateResult parseLocalVersionInfoResult = versionUpdateManager.parseLocalVersionInfo(fileDir + "/ClientVer.xml");
            versionParentNodeInfo = (VersionParentNodeInfo) parseLocalVersionInfoResult.getData();
            if (TextUtils.isEmpty(versionParentNodeInfo.getServerIp())) {
                this.runOnMainThread(new Runnable() {
                    @Override
                    public void run() {
                        callback.onError(context.getResources().getString(R.string.please_check_update_url), null);
                    }
                });
                return false;
            }
            if (TextUtils.isEmpty(versionParentNodeInfo.getServerPort())) {
                this.runOnMainThread(new Runnable() {
                    @Override
                    public void run() {
                        callback.onError(context.getResources().getString(R.string.please_check_update_port), null);
                    }
                });
                return false;
            }

            updateSocket = new UpdateSocket(versionParentNodeInfo.getServerIp(),
                    Integer.parseInt(versionParentNodeInfo.getServerPort()));
            nres = updateSocket.connect();
            if (nres != 0) {
                reWriteConfigInfo();
                this.runOnMainThread(new Runnable() {
                    @Override
                    public void run() {
                        callback.onError(context.getResources().getString(R.string.update_network_is_error), null);
                    }
                });

                return false;
            }
            int fileListNum = fileList.size();
            // 如果update_s.xml文件，更新文件信息为空，就删除掉，认为是无效的update_s.xml文件。
            // 写update_s.xml文件没有写完全会出现该情况。
            if (fileListNum == 0) {
                File file = new File(fileDir + "/update_s.xml");
                file.delete();
                this.runOnMainThread(new Runnable() {
                    @Override
                    public void run() {
                        callback.onError(context.getResources().getString(R.string.update_no_file), null);
                    }
                });
                return false;
            }
            for (int i = 0; i < fileListNum; i++) {
                VersionConfigSubNodeInfo fi = fileList.get(i);
                File targetDir = null;
                if (TextUtils.isEmpty(callback.downloadDir())) {
                    targetDir = new File(fileDir);
                    tfile = new File(fileDir + "/" + fi.getFilename());
                } else {
                    targetDir = new File(callback.downloadDir());
                    tfile = new File(callback.downloadDir() + "/" + fi.getFilename());
                }
                if (!targetDir.exists()) {
                    boolean mkdirs = targetDir.mkdirs();
                    if (!mkdirs) {
                        Log.d(TAG, "============创建目标文件夹出错，请检查文件下载路径是否合法================");
                        this.runOnMainThread(new Runnable() {
                            @Override
                            public void run() {
                                callback.onError(context.getResources().getString(R.string.storage_permission_error), null);
                            }
                        });
                        return false;
                    }
                }
                if (!tfile.exists()) {
                    fi.setState(0);
                    fi.setCsize(0);
                    reWriteConfigInfo();// 重写版本升级配置信息
                }
                // 防止连续追加文件
                if (fi.getCsize() == fi.getFilesize()) {
                    // 安装文件已下载
                    try {
                        String code = versionUpdateManager.getHash(tfile.getAbsolutePath(), "MD5").toLowerCase();
                        String tempCheckCode = versionConfigParentNodeInfo.getCheckCode().toLowerCase();
                        if (!code.equals(tempCheckCode)) {
                            tfile.delete();
                            fi.setState(0);
                            fi.setCsize(0);
                            reWriteConfigInfo();// 重写版本升级配置信息
                            this.runOnMainThread(new Runnable() {
                                @Override
                                public void run() {
                                    callback.onError(context.getResources().getString(R.string.check_file_error_please_down_again), null);
                                }
                            });
                            return false;
                        }
                        return true;
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                //未下载完成
                if (fi.getCsize() < fi.getFilesize()) {
                    //下载升级文件，并修改升级文件的属性
                    final String requestRes = requstUpdateFile(fileListNum, i, fi);
                    //如果手动停止下载，掉用stop函数
                    if ("stop".equals(requestRes)) {
                        this.runOnMainThread(new Runnable() {
                            @Override
                            public void run() {
                                callback.onStop();
                            }
                        });
                        return false;
                    }
                    if (requestRes != null) {
                        this.runOnMainThread(new Runnable() {
                            @Override
                            public void run() {
                                callback.onError(requestRes, null);
                            }
                        });
                        return false;
                    }
                }
            }
            return true;

        } catch (final Exception ex) {
            ex.printStackTrace();
            reWriteConfigInfo();
            this.runOnMainThread(new Runnable() {
                @Override
                public void run() {
                    callback.onError(context.getResources().getString(R.string.unknown_error), ex);
                }
            });
            return false;
        }
    }

    @Override
    protected void onProgressUpdate(Integer... values) {
        progress = values[0];
        callback.onProgress(progress);
        super.onProgressUpdate(values);
    }

    @Override
    protected void onPostExecute(Boolean result) {
        super.onPostExecute(result);
        if (updateSocket != null) {
            updateSocket.close();
            updateSocket = null;
        }
        if (result) {
            callback.onComplete(tfile.getAbsolutePath());
        }
    }

    @Nullable
    private String requstUpdateFile(int fileListNum, int i, VersionConfigSubNodeInfo fi) {
        int nres;// 得到文件大小，与update_s.xml记录的已经下载的文件进行比较，如果不一致
        // 按照实际大小计算

        File dF = new File(callback.downloadDir() + "/" + fi.getFilename());
        if (dF.exists()) {
            if (dF.length() != fi.getCsize()) {
                fi.setCsize((int) dF.length());
            }
        }

        //下载文件请求xml
        StringBuffer getfile = versionUpdateManager.getReqUpdateFileContentXml(fi);

        nres = updateSocket.sendData(getfile.toString());
        if (nres != 0) {
            reWriteConfigInfo();// 重写版本升级配置信息
            return context.getResources().getString(R.string.send_update_file_error_please_again);
        }

        byte[] result = updateSocket.recvData();
        if (result == null) {
            reWriteConfigInfo();// 重写版本升级配置信息// 重写版本升级配置信息
            return context.getResources().getString(R.string.receive_update_file_time_out_check_network);
        } else {
            int res = versionUpdateManager.parseConfirmInfo(result);
            File file = new File(fileDir + "/update_s.xml");
            switch (res) {
                case 0:
                    //下载更新文件
                    String downloadUpdateFileRes = downloadUpdateFile(fileListNum, i, fi);
                    if (downloadUpdateFileRes != null) {
                        return downloadUpdateFileRes;
                    }
                    break;
                case 1:
                    // 删除update_s.xml文件,否则一次不成功就保留该文件无法更新。
                    file.delete();
                    return context.getResources().getString(R.string.update_file_is_not_exsist);
                case 2:
                    file.delete();
                    return context.getResources().getString(R.string.read_file_error);
                case 3:
                    file.delete();
                    return context.getResources().getString(R.string.file_size_error);
                case 4:
                    file.delete();
                    return context.getResources().getString(R.string.not_confirm_data);
                case 5:
                    file.delete();
                    return context.getResources().getString(R.string.param_is_not_complete);
            }

        }
        return null;
    }

    @Nullable
    private String downloadUpdateFile(int fileListNum, int i, VersionConfigSubNodeInfo fi) {
        //接收升级数据超时提示语 add by cxp on 2016-12-13
        String string = context.getResources().getString(R.string.network_failed);
        final String fileNameStr = fi.getFilename();
        while (fi.getCsize() < fi.getFilesize()) {
            if (!isStoped) {
                byte[] data = new byte[fi.getFilesize() - fi.getCsize()];
                int currentLen = 0;
                try {
                    if (updateSocket == null) {
                        return context.getResources().getString(R.string.socket_is_closed);
                    }
                    currentLen = updateSocket.sin.read(data, 0, fi.getFilesize() - fi.getCsize());
                } catch (Exception e) {
                    e.printStackTrace();
                    return string;
                }
                if (currentLen == -1) {
                    reWriteConfigInfo();// 重写版本升级配置信息
                    return string;
                } else {
                    fi.setCsize(fi.getCsize() + currentLen);
                    publishProgress((int) ((fi.getCsize() / (float) fi.getFilesize()) * 100));
                    //防止更新频率过快导致界面无法更新
                    FileOutputStream out = null;
                    try {
                        Thread.sleep(1 * 100);
//                        String tempStr = fileDir + "/" + fi.getFilename();
                        out = new FileOutputStream(tfile, true);
                        out.write(data, 0, currentLen);
                        out.flush();

                    } catch (Exception e) {
                        e.printStackTrace();
                        Log.i("file download fail info", "文件写入错误");
                        tfile.delete();
                        fi.setState(0);
                        fi.setCsize(0);
                        reWriteConfigInfo();// 重写版本升级配置信息
                        return context.getResources().getString(R.string.write_update_file_error);
                    } finally {
                        if (out != null) {
                            try {
                                out.close();
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    if (fi.getCsize() >= fi.getFilesize()) {
                        //下载完成后，修改下载文件权限，检查文件摘要
                        String handleRes = handleDownloadEnd(fi, fileNameStr);
                        if (handleRes != null) {
                            return handleRes;
                        }
                    } else {
                        fi.setState(1);// 文件正在处理
                        reWriteConfigInfo();// 重写版本升级配置信息
                    }
                }
            } else {
                updateSocket.close();
                return "stop";
            }
        }
        Log.i("ffile size", "文件大小为" + tfile.length());
        if (i == fileListNum - 1) {

            SharedPreferences.Editor share = context.getSharedPreferences("jwt", 0).edit();
            share.putString("MainFileName", fi.getFilename()); // 识别程序的文件名，以后删除用，否则会永久不删除
            share.putString("DeleteDb", versionConfigParentNodeInfo.getDeleteDb()); // 是否删除数据库文件
            share.commit();
        }
        return null;
    }

    @Nullable
    private String handleDownloadEnd(VersionConfigSubNodeInfo fi, final String fileNameStr) {
        if (tfile.exists()) {
            new Thread(new Runnable() {
                @Override
                public void run() {
                    try {
                        Runtime.getRuntime().exec("chmod 644 " + callback.downloadDir() + "/" + fileNameStr);
                        Log.v("chmod", "----------chmod power true-----------");
                        Log.i("change ", "权限修改成功");
                    } catch (IOException e) {
                        Log.i("change ", "权限修改失败");
                        e.printStackTrace();
                        e.printStackTrace();
                    }
                }

            }).start();

        }
        // 文件处理完毕
        fi.setState(2);
        // 重写版本升级配置信息
        reWriteConfigInfo();
        // 利用校验码进行校验证
        try {
            String Code = versionUpdateManager.getHash(tfile.getAbsolutePath(), "MD5");
            if (!Code.toLowerCase()
                    .equals(versionConfigParentNodeInfo.getCheckCode()
                            .toLowerCase())) {
                Log.i("checkcode",
                        versionConfigParentNodeInfo.getCheckCode());
                Log.i("Code", Code);
                tfile.delete();
                fi.setState(0);
                fi.setCsize(0);
                reWriteConfigInfo();// 重写版本升级配置信息
                return context.getResources().getString(R.string.check_file_content_error_download_again);

            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }

    private void reWriteConfigInfo() {
        versionUpdateManager.reWriteConfigInfo(fileDir + "/update_s.xml", versionConfigParentNodeInfo);// 重写版本升级配置信息
    }

    private void runOnMainThread(Runnable runnable) {
        this.mainHandler.post(runnable);
    }

    public boolean isClientFileExists(String downloadDir) {
        if (null == fileList || fileList.size() == 0) {
            return false;
        }

        //判断文件是否存在
        int fileListNum = fileList.size();
        for (int i = 0; i < fileListNum; i++) {
            final VersionConfigSubNodeInfo versionConfigSubNodeInfo = fileList.get(i);
            if (versionConfigSubNodeInfo.getAction() == 0) {
                File file = new File(downloadDir + "/" + versionConfigSubNodeInfo.getFilename());
                return file.exists();
            }
        }
        return false;
    }

    /**
     * 检验文件是否完整
     *
     * @return
     */
    public boolean isFileComplete(String downloadDir) {
        int fileListNum = fileList.size();
        for (int i = 0; i < fileListNum; i++) {
            VersionConfigSubNodeInfo fi = fileList.get(i);
            // 防止连续追加文件
            if (fi.getCsize() == 0 || fi.getCsize() == fi.getFilesize()) {
                File file = new File(downloadDir + "/" + fi.getFilename());
                // 后台现在完毕没有安装的情形，第二次登陆进行安装
                if (file.exists()) {
                    try {
                        String code = versionUpdateManager.getHash(downloadDir + "/" + fi.getFilename(),
                                "MD5").toLowerCase();
                        String tempCheckCode = versionConfigParentNodeInfo.getCheckCode().toLowerCase();
                        if (!code.equals(tempCheckCode)) {
                            file.delete();
                            return false;
                        }
                        return true;
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return false;
    }

    public String getFilePath(String downloadDir) {
        String fileName = "";
        //判断文件是否存在
        int fileListNum = fileList.size();
        for (int i = 0; i < fileListNum; i++) {
            final VersionConfigSubNodeInfo versionConfigSubNodeInfo = fileList.get(i);
            if (versionConfigSubNodeInfo.getAction() == 0) {
                fileName = versionConfigSubNodeInfo.getFilename();
            }
        }
        return downloadDir + "/" + fileName;
    }
}
